/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.ResolveState;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodResolverProcessor
extends MethodCandidatesProcessor {
    private boolean myStopAcceptingCandidates;

    public MethodResolverProcessor(@NotNull PsiMethodCallExpression place, @NotNull PsiFile placeFile) {
        this((PsiCallExpression)place, place.getArgumentList(), placeFile);
    }

    public MethodResolverProcessor(@NotNull PsiCallExpression place, @NotNull PsiExpressionList argumentList, @NotNull PsiFile placeFile) {
        this((PsiElement)place, placeFile, new PsiConflictResolver[]{new JavaMethodsConflictResolver(argumentList, PsiUtil.getLanguageLevel((PsiElement)placeFile))});
        this.setArgumentList(argumentList);
        this.obtainTypeArguments(place);
    }

    public MethodResolverProcessor(PsiClass classConstr, @NotNull PsiExpressionList argumentList, @NotNull PsiElement place, @NotNull PsiFile placeFile) {
        super(place, placeFile, new PsiConflictResolver[]{new JavaMethodsConflictResolver(argumentList, PsiUtil.getLanguageLevel((PsiElement)placeFile))}, (List<CandidateInfo>)new SmartList());
        this.setIsConstructor(true);
        this.setAccessClass(classConstr);
        this.setArgumentList(argumentList);
    }

    public MethodResolverProcessor(@NotNull PsiElement place, @NotNull PsiFile placeFile, @NotNull PsiConflictResolver[] resolvers) {
        super(place, placeFile, resolvers, (List<CandidateInfo>)new SmartList());
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myHasAccessibleStaticCorrectCandidate) {
            this.myStopAcceptingCandidates = true;
        }
        super.handleEvent(event, associated);
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        return !this.myStopAcceptingCandidates && super.execute(element, state);
    }

    @Override
    protected boolean acceptVarargs() {
        return true;
    }
}

