/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.ConflictFilterProcessor;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MethodsProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.METHOD;
    private boolean myStaticScopeFlag;
    private boolean myIsConstructor;
    protected PsiElement myCurrentFileContext;
    protected PsiClass myAccessClass;
    private PsiExpressionList myArgumentList;
    private PsiType[] myTypeArguments;
    private final LanguageLevel myLanguageLevel;

    public MethodsProcessor(@NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container, @NotNull PsiElement place, @NotNull PsiFile placeFile) {
        super(null, ourFilter, resolvers, container, place, placeFile);
        this.myLanguageLevel = PsiUtil.getLanguageLevel((PsiElement)placeFile);
    }

    public PsiExpressionList getArgumentList() {
        return this.myArgumentList;
    }

    public void setArgumentList(@Nullable PsiExpressionList argList) {
        this.myArgumentList = argList;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public void obtainTypeArguments(@NotNull PsiCallExpression callExpression) {
        PsiType[] typeArguments = callExpression.getTypeArguments();
        if (typeArguments.length > 0) {
            this.setTypeArguments(typeArguments);
        }
    }

    protected void setTypeArguments(PsiType[] typeParameters) {
        this.myTypeArguments = typeParameters;
    }

    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    public boolean isInStaticScope() {
        return this.myStaticScopeFlag;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    public void setAccessClass(PsiClass accessClass) {
        this.myAccessClass = accessClass;
    }

    public boolean isConstructor() {
        return this.myIsConstructor;
    }

    public void setIsConstructor(boolean myIsConstructor) {
        this.myIsConstructor = myIsConstructor;
    }

    public void forceAddResult(@NotNull PsiMethod method2) {
        this.add(new CandidateInfo((PsiElement)method2, PsiSubstitutor.EMPTY, false, false, this.myCurrentFileContext));
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind2) {
        return kind2 == ElementClassHint.DeclarationKind.METHOD;
    }
}

