/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileNameIndexService;
import com.intellij.psi.search.FileTypeIndexImpl;
import com.intellij.psi.search.FilenameIndexImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileNameIndexServiceImpl
implements FileNameIndexService {
    private final FileBasedIndex myIndex;

    public FileNameIndexServiceImpl(@NotNull FileBasedIndex index) {
        this.myIndex = index;
    }

    @Override
    public Collection<VirtualFile> getVirtualFilesByName(Project project2, String name, GlobalSearchScope scope, IdFilter filter) {
        THashSet files = new THashSet();
        this.myIndex.processValues(FilenameIndexImpl.NAME, (Object)name, null, (arg_0, arg_1) -> FileNameIndexServiceImpl.lambda$getVirtualFilesByName$0((Set)files, arg_0, arg_1), scope, filter);
        return files;
    }

    @Override
    public void processAllFileNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter) {
        this.myIndex.processAllKeys(FilenameIndexImpl.NAME, processor2, scope, filter);
    }

    @Override
    public Collection<VirtualFile> getFilesWithFileType(FileType fileType, GlobalSearchScope scope) {
        return this.myIndex.getContainingFiles(FileTypeIndexImpl.NAME, (Object)fileType, scope);
    }

    @Override
    public boolean processFilesWithFileType(FileType fileType, Processor<VirtualFile> processor2, GlobalSearchScope scope) {
        return this.myIndex.processValues(FileTypeIndexImpl.NAME, (Object)fileType, null, (file2, value2) -> processor2.process((Object)file2), scope);
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByName$0(Set files, VirtualFile file2, Void value2) {
        files.add(file2);
        return true;
    }
}

