/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileTypeIndexImpl
extends ScalarIndexExtension<FileType>
implements FileBasedIndex.InputFilter,
KeyDescriptor<FileType>,
DataIndexer<FileType, Void, FileContent> {
    static final ID<FileType, Void> NAME = FileTypeIndex.NAME;
    private final FileTypeRegistry myFileTypeManager;

    public FileTypeIndexImpl(FileTypeRegistry fileTypeRegistry) {
        this.myFileTypeManager = fileTypeRegistry;
    }

    @NotNull
    public ID<FileType, Void> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<FileType, Void, FileContent> getIndexer() {
        return this;
    }

    @NotNull
    public KeyDescriptor<FileType> getKeyDescriptor() {
        return this;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return this;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    public int getVersion() {
        FileType[] types = this.myFileTypeManager.getRegisteredFileTypes();
        int version = 2;
        for (FileType fileType : types) {
            version += fileType.getName().hashCode();
        }
        version *= 31;
        for (FileType fileType : (FileTypeRegistry.FileTypeDetector[])Extensions.getExtensions((ExtensionPointName)FileTypeRegistry.FileTypeDetector.EP_NAME)) {
            version += fileType.getVersion();
        }
        return version;
    }

    public boolean acceptInput(@NotNull VirtualFile file2) {
        return !file2.isDirectory();
    }

    public void save(@NotNull DataOutput out, FileType value2) throws IOException {
        EnumeratorStringDescriptor.INSTANCE.save(out, value2.getName());
    }

    public FileType read(@NotNull DataInput in) throws IOException {
        String read2 = EnumeratorStringDescriptor.INSTANCE.read(in);
        return this.myFileTypeManager.findFileTypeByName(read2);
    }

    public int getHashCode(FileType value2) {
        return value2.getName().hashCode();
    }

    public boolean isEqual(FileType val1, FileType val2) {
        if (val1 instanceof SubstitutedFileType) {
            val1 = ((SubstitutedFileType)val1).getOriginalFileType();
        }
        if (val2 instanceof SubstitutedFileType) {
            val2 = ((SubstitutedFileType)val2).getOriginalFileType();
        }
        return Comparing.equal((Object)val1, (Object)val2);
    }

    @NotNull
    public Map<FileType, Void> map(@NotNull FileContent inputData) {
        return Collections.singletonMap(inputData.getFileType(), null);
    }

    public static boolean containsFileOfType(@NotNull FileType type2, @NotNull GlobalSearchScope scope) {
        return !FileTypeIndexImpl.processFiles(type2, (Processor<VirtualFile>)((Processor)file2 -> false), scope);
    }

    @NotNull
    public static Collection<VirtualFile> getFiles(@NotNull FileType fileType, @NotNull GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)fileType, scope);
    }

    public static boolean processFiles(@NotNull FileType fileType, @NotNull Processor<VirtualFile> processor2, GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().processValues(NAME, (Object)fileType, null, (file2, value2) -> processor2.process((Object)file2), scope);
    }
}

