/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.FileNameIndexService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex {
    @Deprecated
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FilenameIndex");

    public static String[] getAllFilenames(Project project2) {
        THashSet names = new THashSet();
        FilenameIndex.getService().processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getAllFilenames$0((Set)names, arg_0)), (GlobalSearchScope)(project2 == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project2)), null);
        return ArrayUtil.toStringArray((Collection)names);
    }

    public static void processAllFileNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter) {
        FilenameIndex.getService().processAllFileNames(processor2, scope, filter);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project2, String name, GlobalSearchScope scope) {
        return FilenameIndex.getService().getVirtualFilesByName(project2, name, scope, null);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project2, String name, boolean caseSensitively, GlobalSearchScope scope) {
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(project2, name, scope);
        }
        return FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project2, null);
    }

    public static PsiFile[] getFilesByName(Project project2, String name, GlobalSearchScope scope) {
        return (PsiFile[])FilenameIndex.getFilesByName(project2, name, scope, false);
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        return FilenameIndex.processFilesByName(name, includeDirs, true, processor2, scope, project2, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        Collection<VirtualFile> files = caseSensitively ? FilenameIndex.getService().getVirtualFilesByName(project2, name, scope, idFilter) : FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project2, idFilter);
        if (files.isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        int processedFiles = 0;
        for (VirtualFile file2 : files) {
            PsiDirectory dir;
            if (!file2.isValid()) continue;
            if (!includeDirs && !file2.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file2);
                if (psiFile == null) continue;
                if (!processor2.process((Object)psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!includeDirs || !file2.isDirectory() || (dir = psiManager.findDirectory(file2)) == null) continue;
            if (!processor2.process((Object)dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(@NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        THashSet keys = new THashSet();
        FileNameIndexService fileNameIndexService = FilenameIndex.getService();
        fileNameIndexService.processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getVirtualFilesByNameIgnoringCase$1(name, (Set)keys, arg_0)), scope, idFilter);
        THashSet files = new THashSet();
        for (String each : keys) {
            files.addAll(fileNameIndexService.getVirtualFilesByName(project2, each, scope, idFilter));
        }
        return files;
    }

    public static PsiFileSystemItem[] getFilesByName(Project project2, String name, @NotNull GlobalSearchScope scope, boolean includeDirs) {
        SmartList result2 = new SmartList();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)result2);
        FilenameIndex.processFilesByName(name, includeDirs, (Processor<? super PsiFileSystemItem>)processor2, scope, project2, null);
        if (includeDirs) {
            return (PsiFileSystemItem[])ArrayUtil.toObjectArray((Collection)result2, PsiFileSystemItem.class);
        }
        return (PsiFileSystemItem[])result2.toArray((Object[])new PsiFile[result2.size()]);
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project2, @NotNull String ext) {
        return FilenameIndex.getAllFilesByExt(project2, ext, GlobalSearchScope.allScope((Project)project2));
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project2, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        int len = ext.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project2)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files.addAll(FilenameIndex.getVirtualFilesByName(project2, name, searchScope));
        }
        return files;
    }

    static FileNameIndexService getService() {
        return (FileNameIndexService)ServiceManager.getService(FileNameIndexService.class);
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByNameIgnoringCase$1(@NotNull String name, Set keys, String value2) {
        if (name.equalsIgnoreCase(value2)) {
            keys.add(value2);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getAllFilenames$0(Set names, String s) {
        names.add(s);
        return true;
    }
}

