/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FilenameIndexImpl
extends ScalarIndexExtension<String> {
    @NonNls
    static final ID<String, Void> NAME = FilenameIndex.NAME;

    @NotNull
    public ID<String, Void> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                return Collections.singletonMap(inputData.getFileName(), null);
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new FileBasedIndex.InputFilter(){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                return file2 instanceof VirtualFileSystemEntry;
            }
        };
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    public boolean indexDirectories() {
        return true;
    }

    public int getVersion() {
        return 2 + (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping ? 1 : 0);
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }
}

