/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeImpl
extends GlobalSearchScope {
    private final FileIndexFacade myFileIndex;

    public ProjectScopeImpl(@NotNull Project project2, @NotNull FileIndexFacade fileIndex) {
        super(project2);
        this.myFileIndex = fileIndex;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 instanceof VirtualFileWindow) {
            return true;
        }
        if (this.myFileIndex.isInLibraryClasses(file2) && !this.myFileIndex.isInSourceContent(file2)) {
            return false;
        }
        return this.myFileIndex.isInContent(file2);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return true;
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == this || !scope.isSearchInLibraries() || !scope.isSearchOutsideRootModel()) {
            return this;
        }
        return super.uniteWith(scope);
    }

    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == this) {
            return this;
        }
        if (!scope.isSearchInLibraries()) {
            return scope;
        }
        return super.intersectWith(scope);
    }
}

