/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.statistics.impl.StatisticsUnit;
import com.intellij.psi.statistics.impl.WrongFormatException;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ScrambledInputStream;
import com.intellij.util.ScrambledOutputStream;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StatisticsManagerImpl
extends StatisticsManager {
    private static final int UNIT_COUNT = 997;
    private static final Object LOCK = new Object();
    @NonNls
    private static final String STORE_PATH = PathManager.getSystemPath() + File.separator + "stat";
    private final List<SoftReference<StatisticsUnit>> myUnits = ContainerUtil.newArrayList(Collections.nCopies(997, null));
    private final HashSet<StatisticsUnit> myModifiedUnits = new HashSet();
    private boolean myTestingStatistics;

    public int getUseCount(@NotNull StatisticsInfo info) {
        if (info == StatisticsInfo.EMPTY) {
            return 0;
        }
        int useCount = 0;
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            useCount = Math.max(this.doGetUseCount(conjunct), useCount);
        }
        return useCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doGetUseCount(StatisticsInfo info) {
        String key1 = info.getContext();
        int unitNumber = StatisticsManagerImpl.getUnitNumber(key1);
        Object object = LOCK;
        synchronized (object) {
            StatisticsUnit unit = this.getUnit(unitNumber);
            return unit.getData(key1, info.getValue());
        }
    }

    public int getLastUseRecency(@NotNull StatisticsInfo info) {
        if (info == StatisticsInfo.EMPTY) {
            return 0;
        }
        int recency = Integer.MAX_VALUE;
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            recency = Math.min(this.doGetRecency(conjunct), recency);
        }
        return recency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doGetRecency(StatisticsInfo info) {
        String key1 = info.getContext();
        int unitNumber = StatisticsManagerImpl.getUnitNumber(key1);
        Object object = LOCK;
        synchronized (object) {
            StatisticsUnit unit = this.getUnit(unitNumber);
            return unit.getRecency(key1, info.getValue());
        }
    }

    public void incUseCount(@NotNull StatisticsInfo info) {
        if (info == StatisticsInfo.EMPTY) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !this.myTestingStatistics) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            this.doIncUseCount(conjunct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIncUseCount(StatisticsInfo info) {
        String key1 = info.getContext();
        int unitNumber = StatisticsManagerImpl.getUnitNumber(key1);
        Object object = LOCK;
        synchronized (object) {
            StatisticsUnit unit = this.getUnit(unitNumber);
            unit.incData(key1, info.getValue());
            this.myModifiedUnits.add(unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticsInfo[] getAllValues(String context) {
        Object[] strings;
        Object object = LOCK;
        synchronized (object) {
            strings = this.getUnit(StatisticsManagerImpl.getUnitNumber(context)).getKeys2(context);
        }
        return (StatisticsInfo[])ContainerUtil.map2Array((Object[])strings, StatisticsInfo.class, (Function)((NotNullFunction)s -> new StatisticsInfo(context, s)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Object object = LOCK;
        synchronized (object) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                for (StatisticsUnit unit : this.myModifiedUnits) {
                    this.saveUnit(unit.getNumber());
                }
            }
            this.myModifiedUnits.clear();
        }
    }

    private StatisticsUnit getUnit(int unitNumber) {
        StatisticsUnit unit = (StatisticsUnit)SoftReference.dereference((Reference)((Reference)this.myUnits.get(unitNumber)));
        if (unit != null) {
            return unit;
        }
        unit = StatisticsManagerImpl.loadUnit(unitNumber);
        if (unit == null) {
            unit = new StatisticsUnit(unitNumber);
        }
        this.myUnits.set(unitNumber, (SoftReference<StatisticsUnit>)new SoftReference((Object)unit));
        return unit;
    }

    private static StatisticsUnit loadUnit(int unitNumber) {
        StatisticsUnit unit = new StatisticsUnit(unitNumber);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            String path = StatisticsManagerImpl.getPathToUnit(unitNumber);
            try (ScrambledInputStream in = new ScrambledInputStream(new BufferedInputStream(new FileInputStream(path)));){
                unit.read(in);
            }
            catch (WrongFormatException | IOException exception) {
                // empty catch block
            }
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUnit(int unitNumber) {
        if (!StatisticsManagerImpl.createStoreFolder()) {
            return;
        }
        StatisticsUnit unit = this.getUnit(unitNumber);
        String path = StatisticsManagerImpl.getPathToUnit(unitNumber);
        try {
            OutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            out = new ScrambledOutputStream(out);
            try {
                unit.write(out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.saving.statistics", (Object[])new Object[]{e.getLocalizedMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        }
    }

    private static int getUnitNumber(String key1) {
        return Math.abs(key1.hashCode()) % 997;
    }

    private static boolean createStoreFolder() {
        File homeFile = new File(STORE_PATH);
        if (!homeFile.exists() && !homeFile.mkdirs()) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.saving.statistic.failed.to.create.folder", (Object[])new Object[]{STORE_PATH}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    private static String getPathToUnit(int unitNumber) {
        return STORE_PATH + File.separator + "unit." + unitNumber;
    }

    public void enableStatistics(@NotNull Disposable parentDisposable) {
        this.myTestingStatistics = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = LOCK;
                synchronized (object) {
                    Collections.fill(StatisticsManagerImpl.this.myUnits, null);
                }
                StatisticsManagerImpl.this.myTestingStatistics = false;
            }
        });
    }
}

