/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IndexingStampInfo {
    final long indexingFileStamp;
    final long indexingContentLength;

    IndexingStampInfo(long indexingFileStamp, long indexingContentLength) {
        this.indexingFileStamp = indexingFileStamp;
        this.indexingContentLength = indexingContentLength;
    }

    public String toString() {
        return "indexed at " + this.indexingFileStamp + " with document size " + this.indexingContentLength;
    }

    public boolean isUpToDate(@Nullable Document document, @NotNull VirtualFile file2, @NotNull PsiFile psi) {
        if (document == null || FileDocumentManager.getInstance().isDocumentUnsaved(document) || !PsiDocumentManager.getInstance((Project)psi.getProject()).isCommitted(document)) {
            return false;
        }
        return this.indexingFileStamp == file2.getTimeStamp() && this.indexingContentLength == (long)document.getTextLength();
    }
}

