/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexState;
import com.intellij.psi.stubs.StubProcessingHelper;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IdIterator;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileBasedIndex", storages={@Storage(value="stubIndex.xml", roamingType=RoamingType.DISABLED)})
public class StubIndexImpl
extends StubIndex
implements ApplicationComponentAdapter,
PersistentStateComponent<StubIndexState> {
    private static final AtomicReference<Boolean> ourForcedClean = new AtomicReference<Object>(null);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubIndexImpl");
    private final StubProcessingHelper myStubProcessingHelper;
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();
    private volatile Future<AsyncState> myStateFuture;
    private volatile AsyncState myState;
    private volatile boolean myInitialized;
    private StubIndexState myPreviouslyRegistered;

    public StubIndexImpl(FileBasedIndex fileBasedIndex) throws IOException {
        this.myStubProcessingHelper = new StubProcessingHelper(fileBasedIndex);
    }

    @Nullable
    static StubIndexImpl getInstanceOrInvalidate() {
        if (ourForcedClean.compareAndSet(null, Boolean.TRUE)) {
            return null;
        }
        return (StubIndexImpl)StubIndexImpl.getInstance();
    }

    private AsyncState getAsyncState() {
        AsyncState state = this.myState;
        if (state == null) {
            try {
                this.myState = state = this.myStateFuture.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K> boolean registerIndexer(final @NotNull StubIndexExtension<K, ?> extension, boolean forceClean, AsyncState state) throws IOException {
        final StubIndexKey indexKey = extension.getKey();
        int version = extension.getVersion();
        AsyncState asyncState = state;
        synchronized (asyncState) {
            state.myIndexIdToVersionMap.put((Object)indexKey, version);
        }
        File versionFile = IndexInfrastructure.getVersionFile(indexKey);
        boolean versionFileExisted = versionFile.exists();
        File indexRootDir = IndexInfrastructure.getIndexRootDir(indexKey);
        boolean needRebuild = false;
        if (forceClean || IndexingStamp.versionDiffers(versionFile, version)) {
            String[] children2 = indexRootDir.list();
            boolean indexRootHasChildren = children2 != null && children2.length > 0;
            boolean bl = needRebuild = !forceClean && (versionFileExisted || indexRootHasChildren);
            if (needRebuild) {
                LOG.info("Version has changed for stub index " + extension.getKey() + ". The index will be rebuilt.");
            }
            if (indexRootHasChildren) {
                FileUtil.deleteWithRenaming((File)indexRootDir);
            }
            IndexingStamp.rewriteVersion(versionFile, version);
        }
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                VfsAwareMapIndexStorage storage2 = new VfsAwareMapIndexStorage(IndexInfrastructure.getStorageFile(indexKey), extension.getKeyDescriptor(), StubIdExternalizer.INSTANCE, extension.getCacheSize(), false, extension instanceof StringStubIndexExtension && ((StringStubIndexExtension)extension).traceKeyHashToVirtualFileMapping());
                MemoryIndexStorage memStorage = new MemoryIndexStorage(storage2, (ID<?, ?>)indexKey);
                MyIndex index = new MyIndex(new IndexExtension<K, StubIdList, Void>(){

                    @NotNull
                    public ID<K, StubIdList> getName() {
                        return indexKey;
                    }

                    @NotNull
                    public DataIndexer<K, StubIdList, Void> getIndexer() {
                        return inputData -> Collections.emptyMap();
                    }

                    @NotNull
                    public KeyDescriptor<K> getKeyDescriptor() {
                        return extension.getKeyDescriptor();
                    }

                    @NotNull
                    public DataExternalizer<StubIdList> getValueExternalizer() {
                        return StubIdExternalizer.INSTANCE;
                    }

                    public int getVersion() {
                        return extension.getVersion();
                    }
                }, memStorage);
                AsyncState asyncState2 = state;
                synchronized (asyncState2) {
                    state.myIndices.put(indexKey, index);
                    break;
                }
            }
            catch (IOException e) {
                needRebuild = true;
                StubIndexImpl.onExceptionInstantiatingIndex(version, versionFile, indexRootDir, e);
                continue;
            }
            catch (RuntimeException e) {
                Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                if (cause == null) {
                    throw e;
                }
                StubIndexImpl.onExceptionInstantiatingIndex(version, versionFile, indexRootDir, e);
            }
        }
        return needRebuild;
    }

    private static void onExceptionInstantiatingIndex(int version, File versionFile, File indexRootDir, Exception e) throws IOException {
        LOG.info((Throwable)e);
        FileUtil.deleteWithRenaming((File)indexRootDir);
        IndexingStamp.rewriteVersion(versionFile, version);
    }

    public long getIndexModificationStamp(StubIndexKey<?, ?> indexId, @NotNull Project project2) {
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(indexId);
        if (index != null) {
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project2, GlobalSearchScope.allScope((Project)project2));
            return index.getModificationStamp();
        }
        return -1L;
    }

    public void flush() throws StorageException {
        if (!this.myInitialized) {
            return;
        }
        AsyncState state = this.getAsyncState();
        for (StubIndexKey key2 : this.getAllStubIndexKeys()) {
            MyIndex index = (MyIndex)state.myIndices.get(key2);
            index.flush();
        }
    }

    public <K> void serializeIndexValue(DataOutput out, StubIndexKey<K, ?> stubIndexKey, Map<K, StubIdList> map2) throws IOException {
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(stubIndexKey);
        KeyDescriptor keyDescriptor = index.getExtension().getKeyDescriptor();
        DataInputOutputUtil.writeINT((DataOutput)out, (int)map2.size());
        for (K key2 : map2.keySet()) {
            keyDescriptor.save(out, key2);
            StubIdExternalizer.INSTANCE.save(out, map2.get(key2));
        }
    }

    public <K> Map<K, StubIdList> deserializeIndexValue(DataInput in, StubIndexKey<K, ?> stubIndexKey) throws IOException {
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(stubIndexKey);
        KeyDescriptor keyDescriptor = index.getExtension().getKeyDescriptor();
        int mapSize = DataInputOutputUtil.readINT((DataInput)in);
        THashMap result2 = new THashMap(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            Object key2 = keyDescriptor.read(in);
            StubIdList read2 = StubIdExternalizer.INSTANCE.read(in);
            result2.put(key2, read2);
        }
        return result2;
    }

    @NotNull
    public <Key, Psi extends PsiElement> Collection<Psi> get(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key2, @NotNull Project project2, @Nullable GlobalSearchScope scope) {
        return this.get(indexKey, key2, project2, scope, null);
    }

    public <Key, Psi extends PsiElement> Collection<Psi> get(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key2, @NotNull Project project2, @Nullable GlobalSearchScope scope, IdFilter filter) {
        SmartList result2 = new SmartList();
        this.process(indexKey, key2, project2, scope, filter, Processors.cancelableCollectProcessor((Collection)result2));
        return result2;
    }

    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key2, @NotNull Project project2, @Nullable GlobalSearchScope scope, Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor2) {
        return this.processElements(indexKey, key2, project2, scope, null, requiredClass, processor2);
    }

    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key2, final @NotNull Project project2, final @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, final @NotNull Class<Psi> requiredClass, final @NotNull Processor<? super Psi> processor2) {
        return this.doProcessStubs(indexKey, key2, project2, scope, new StubIdListContainerAction(idFilter, project2){
            final PersistentFS fs;
            {
                super(idFilter, project22);
                this.fs = (PersistentFS)ManagingFS.getInstance();
            }

            @Override
            protected boolean process(int id, StubIdList value2) {
                VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(this.fs, id);
                if (file2 == null || scope != null && !scope.contains(file2)) {
                    return true;
                }
                return StubIndexImpl.this.myStubProcessingHelper.processStubsInFile(project2, file2, value2, processor2, requiredClass);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Key> boolean doProcessStubs(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key2, @NotNull Project project2, @Nullable GlobalSearchScope scope, @NotNull StubIdListContainerAction action) {
        block7: {
            boolean bl;
            FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
            fileBasedIndex.ensureUpToDate(StubUpdatingIndex.INDEX_ID, project2, scope);
            MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(indexKey);
            this.myAccessValidator.checkAccessingIndexDuringOtherIndexProcessing((ID<?, ?>)indexKey);
            try {
                FileBasedIndexImpl.disableUpToDateCheckForCurrentThread();
                index.getReadLock().lock();
                this.myAccessValidator.startedProcessingActivityForIndex((ID<?, ?>)indexKey);
                bl = index.getData(key2).forEach((ValueContainer.ContainerAction)action);
                this.myAccessValidator.stoppedProcessingActivityForIndex((ID<?, ?>)indexKey);
                index.getReadLock().unlock();
            }
            catch (Throwable throwable) {
                try {
                    this.myAccessValidator.stoppedProcessingActivityForIndex((ID<?, ?>)indexKey);
                    index.getReadLock().unlock();
                    FileBasedIndexImpl.enableUpToDateCheckForCurrentThread();
                    throw throwable;
                }
                catch (StorageException | AssertionError e) {
                    this.forceRebuild((Throwable)e);
                    break block7;
                }
                catch (RuntimeException e) {
                    Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                    if (cause != null) {
                        this.forceRebuild(cause);
                        break block7;
                    }
                    throw e;
                }
            }
            FileBasedIndexImpl.enableUpToDateCheckForCurrentThread();
            return bl;
        }
        return true;
    }

    public void forceRebuild(@NotNull Throwable e) {
        LOG.info(e);
        FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, e);
    }

    private static void requestRebuild() {
        FileBasedIndex.getInstance().requestRebuild(StubUpdatingIndex.INDEX_ID);
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project2) {
        THashSet allKeys = ContainerUtil.newTroveSet();
        this.processAllKeys(indexKey, project2, Processors.cancelableCollectProcessor((Collection)allKeys));
        return allKeys;
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project2, Processor<K> processor2) {
        return this.processAllKeys(indexKey, processor2, GlobalSearchScope.allScope((Project)project2), null);
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Processor<K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, scope.getProject(), scope);
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(indexKey);
        this.myAccessValidator.checkAccessingIndexDuringOtherIndexProcessing((ID<?, ?>)indexKey);
        try {
            this.myAccessValidator.startedProcessingActivityForIndex((ID<?, ?>)indexKey);
            boolean bl = index.processAllKeys(processor2, scope, idFilter);
            return bl;
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                this.forceRebuild(e);
            }
            throw e;
        }
        finally {
            this.myAccessValidator.stoppedProcessingActivityForIndex((ID<?, ?>)indexKey);
        }
        return true;
    }

    @NotNull
    public <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        final TIntArrayList result2 = new TIntArrayList();
        this.doProcessStubs(indexKey, dataKey, project2, scope, new StubIdListContainerAction(null, project2){

            @Override
            protected boolean process(int id, StubIdList value2) {
                result2.add(id);
                return true;
            }
        });
        return new IdIterator(){
            int cursor;

            public boolean hasNext() {
                return this.cursor < result2.size();
            }

            public int next() {
                return result2.get(this.cursor++);
            }

            public int size() {
                return result2.size();
            }
        };
    }

    public void initComponent() {
        long started = System.nanoTime();
        StubIndexExtension[] extensions = (StubIndexExtension[])Extensions.getExtensions((ExtensionPointName)StubIndexExtension.EP_NAME);
        LOG.info("All stub exts enumerated:" + (System.nanoTime() - started) / 1000000L);
        started = System.nanoTime();
        this.myStateFuture = IndexInfrastructure.submitGenesisTask(new StubIndexInitialization(extensions));
        LOG.info("stub exts update scheduled:" + (System.nanoTime() - started) / 1000000L);
        if (!IndexInfrastructure.ourDoAsyncIndicesInitialization) {
            try {
                this.myStateFuture.get();
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    public void dispose() {
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            index.dispose();
        }
    }

    public void setDataBufferingEnabled(boolean enabled) {
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            IndexStorage indexStorage = ((VfsAwareMapReduceIndex)index).getStorage();
            ((MemoryIndexStorage)indexStorage).setBufferingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupMemoryStorage() {
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            IndexStorage indexStorage = ((VfsAwareMapReduceIndex)index).getStorage();
            index.getWriteLock().lock();
            try {
                ((MemoryIndexStorage)indexStorage).clearMemoryMap();
            }
            finally {
                index.getWriteLock().unlock();
            }
        }
    }

    public void clearAllIndices() {
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            try {
                index.clear();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void dropUnregisteredIndices(AsyncState state) {
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        HashSet indicesToDrop = new HashSet(this.myPreviouslyRegistered != null ? this.myPreviouslyRegistered.registeredIndices : Collections.emptyList());
        for (ID key2 : state.myIndices.keySet()) {
            indicesToDrop.remove(key2.toString());
        }
        if (!indicesToDrop.isEmpty()) {
            LOG.info("Dropping indices:" + StringUtil.join(indicesToDrop, (String)","));
            for (String s : indicesToDrop) {
                FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(StubIndexKey.createIndexKey((String)s)));
            }
        }
    }

    public StubIndexState getState() {
        if (!this.myInitialized) {
            return null;
        }
        return new StubIndexState(this.getAsyncState().myIndices.keySet());
    }

    public void loadState(StubIndexState state) {
        this.myPreviouslyRegistered = state;
    }

    public final Lock getWriteLock(StubIndexKey indexKey) {
        return ((MyIndex)this.getAsyncState().myIndices.get(indexKey)).getWriteLock();
    }

    Collection<StubIndexKey> getAllStubIndexKeys() {
        return Collections.unmodifiableCollection(this.getAsyncState().myIndices.keySet());
    }

    public <K> void updateIndex(@NotNull StubIndexKey key2, int fileId, @NotNull Map<K, StubIdList> oldValues, @NotNull Map<K, StubIdList> newValues) {
        try {
            MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(key2);
            ThrowableComputable oldMapGetter = () -> new MapInputDataDiffBuilder(fileId, oldValues);
            index.updateWithMap(fileId, new UpdateData(newValues, oldMapGetter, (ID)key2, null));
        }
        catch (StorageException e) {
            LOG.info((Throwable)e);
            StubIndexImpl.requestRebuild();
        }
    }

    private class StubIndexInitialization
    extends IndexInfrastructure.DataInitialization<AsyncState> {
        private final AsyncState state = new AsyncState();
        private final StringBuilder updated = new StringBuilder();
        private final StubIndexExtension<?, ?>[] myExtensions;

        public StubIndexInitialization(StubIndexExtension<?, ?>[] extensions) {
            this.myExtensions = extensions;
        }

        @Override
        protected void prepare() {
            boolean forceClean = Boolean.TRUE == ourForcedClean.getAndSet(Boolean.FALSE);
            for (StubIndexExtension<?, ?> extension : this.myExtensions) {
                this.addNestedInitializationTask(() -> {
                    boolean rebuildRequested = StubIndexImpl.registerIndexer(extension, forceClean, this.state);
                    if (rebuildRequested) {
                        StringBuilder stringBuilder = this.updated;
                        synchronized (stringBuilder) {
                            this.updated.append(extension).append(' ');
                        }
                    }
                });
            }
        }

        @Override
        protected void onThrowable(Throwable t) {
            LOG.error(t);
        }

        @Override
        protected AsyncState finish() {
            if (this.updated.length() > 0) {
                Throwable e = new Throwable(this.updated.toString());
                ApplicationManager.getApplication().invokeLater(() -> StubIndexImpl.this.forceRebuild(e), ModalityState.NON_MODAL);
            }
            StubIndexImpl.this.dropUnregisteredIndices(this.state);
            StubIndexImpl.this.myInitialized = true;
            return this.state;
        }
    }

    private static abstract class StubIdListContainerAction
    implements ValueContainer.ContainerAction<StubIdList> {
        private final IdFilter myIdFilter;

        StubIdListContainerAction(@Nullable IdFilter idFilter, @NotNull Project project2) {
            this.myIdFilter = idFilter != null ? idFilter : ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project2);
        }

        public boolean perform(int id, @NotNull StubIdList value2) {
            ProgressManager.checkCanceled();
            if (this.myIdFilter != null && !this.myIdFilter.containsFileId(id)) {
                return true;
            }
            return this.process(id, value2);
        }

        protected abstract boolean process(int var1, StubIdList var2);
    }

    private static class MyIndex<K>
    extends VfsAwareMapReduceIndex<K, StubIdList, Void> {
        public MyIndex(IndexExtension<K, StubIdList, Void> extension, IndexStorage<K, StubIdList> storage2) throws IOException {
            super(extension, storage2);
        }

        public void updateWithMap(int inputId, @NotNull UpdateData<K, StubIdList> updateData) throws StorageException {
            super.updateWithMap(inputId, updateData);
        }

        public IndexExtension<K, StubIdList, Void> getExtension() {
            return this.myExtension;
        }
    }

    private static class StubIdExternalizer
    implements DataExternalizer<StubIdList> {
        private static final StubIdExternalizer INSTANCE = new StubIdExternalizer();

        private StubIdExternalizer() {
        }

        public void save(@NotNull DataOutput out, @NotNull StubIdList value2) throws IOException {
            int size = value2.size();
            if (size == 0) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)Integer.MAX_VALUE);
            } else if (size == 1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.get(0));
            } else {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-size));
                for (int i = 0; i < size; ++i) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.get(i));
                }
            }
        }

        @NotNull
        public StubIdList read(@NotNull DataInput in) throws IOException {
            int size = DataInputOutputUtil.readINT((DataInput)in);
            if (size == Integer.MAX_VALUE) {
                return new StubIdList();
            }
            if (size >= 0) {
                return new StubIdList(size);
            }
            size = -size;
            int[] result2 = new int[size];
            for (int i = 0; i < size; ++i) {
                result2[i] = DataInputOutputUtil.readINT((DataInput)in);
            }
            return new StubIdList(result2, size);
        }
    }

    private static class AsyncState {
        private final Map<StubIndexKey<?, ?>, MyIndex<?>> myIndices = new THashMap();
        private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();

        private AsyncState() {
        }
    }
}

