/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubsHierarchy.HierarchyService;
import com.intellij.psi.stubsHierarchy.impl.AnchorRepository;
import com.intellij.psi.stubsHierarchy.impl.SerializedUnit;
import com.intellij.psi.stubsHierarchy.impl.SingleClassHierarchy;
import com.intellij.psi.stubsHierarchy.impl.StubEnter;
import com.intellij.psi.stubsHierarchy.impl.StubHierarchyIndex;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CachedValueBase;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class HierarchyServiceImpl
extends HierarchyService {
    private static final SingleClassHierarchy EMPTY_HIERARCHY = new SingleClassHierarchy(Symbol.ClassSymbol.EMPTY_ARRAY, new AnchorRepository());
    private final Project myProject;
    private final CachedValue<SingleClassHierarchy> myHierarchy;

    public HierarchyServiceImpl(Project project2) {
        this.myProject = project2;
        this.myHierarchy = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.buildHierarchy(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SingleClassHierarchy getHierarchy() {
        if (!IndexTree.STUB_HIERARCHY_ENABLED) {
            return EMPTY_HIERARCHY;
        }
        CachedValue<SingleClassHierarchy> cachedValue = this.myHierarchy;
        synchronized (cachedValue) {
            return (SingleClassHierarchy)this.myHierarchy.getValue();
        }
    }

    @Override
    public void clearHierarchy() {
        ((CachedValueBase)this.myHierarchy).clear();
    }

    private SingleClassHierarchy buildHierarchy() {
        Symbols symbols = new Symbols();
        StubEnter stubEnter = new StubEnter(symbols);
        IdSets idSets = IdSets.getIdSets(this.myProject);
        this.loadUnits(idSets.libraryFiles, StubHierarchyIndex.BINARY_KEYS, stubEnter);
        stubEnter.connect1();
        this.loadUnits(idSets.sourceFiles, StubHierarchyIndex.SOURCE_KEYS, stubEnter);
        stubEnter.connect2();
        return symbols.createHierarchy();
    }

    private void loadUnits(final BitSet files, int[] indexKeys, final StubEnter stubEnter) {
        FileBasedIndexImpl.IdValueProcessor<SerializedUnit> processor2 = new FileBasedIndexImpl.IdValueProcessor<SerializedUnit>(){
            final ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            int count = 0;

            @Override
            public boolean process(int fileId, SerializedUnit unit) {
                if (this.indicator != null && ++this.count % 128 == 0) {
                    this.indicator.checkCanceled();
                }
                if (files.get(fileId)) {
                    unit.readUnit(stubEnter, fileId);
                }
                return true;
            }
        };
        for (int indexKey : indexKeys) {
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).processAllValues(StubHierarchyIndex.INDEX_ID, indexKey, this.myProject, processor2);
        }
    }

    private static class IdSets {
        final BitSet sourceFiles = new BitSet();
        final BitSet libraryFiles = new BitSet();

        private IdSets() {
        }

        static IdSets getIdSets(@NotNull Project project2) {
            return (IdSets)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> {
                IdSets answer = new IdSets();
                ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project2);
                FileBasedIndex.getInstance().iterateIndexableFiles(file2 -> {
                    if (!file2.isDirectory() && file2 instanceof VirtualFileWithId) {
                        if (index.isInSourceContent(file2)) {
                            answer.sourceFiles.set(((VirtualFileWithId)file2).getId());
                        } else if (index.isInLibraryClasses(file2)) {
                            answer.libraryFiles.set(((VirtualFileWithId)file2).getId());
                        }
                    }
                    return true;
                }, project2, ProgressIndicatorProvider.getGlobalProgressIndicator());
                return CachedValueProvider.Result.create((Object)answer, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project2), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
            });
        }
    }
}

