/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubsHierarchy.ClassHierarchy;
import com.intellij.psi.stubsHierarchy.SmartClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.AnchorRepository;
import com.intellij.psi.stubsHierarchy.impl.StubClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleClassHierarchy
extends ClassHierarchy {
    private final BitSet myCoveredFiles;
    private final BitSet myAmbiguousSupers;
    private final BitSet myAnonymous;
    private final AnchorRepository myClassAnchors;
    private final int[] myClassAnchorsByFileIds;
    private int[] mySubtypes;
    private int[] mySubtypeStarts;

    public SingleClassHierarchy(Symbol.ClassSymbol[] classSymbols, AnchorRepository classAnchors) {
        classAnchors.trimToSize();
        this.myClassAnchors = classAnchors;
        this.myCoveredFiles = this.calcCoveredFiles(classSymbols);
        this.myClassAnchorsByFileIds = this.mkByFileId();
        this.excludeUncoveredFiles(classSymbols);
        this.connectSubTypes(classSymbols);
        this.myAmbiguousSupers = SingleClassHierarchy.calcAmbiguousSupers(classSymbols);
        this.myAnonymous = SingleClassHierarchy.calcAnonymous(classSymbols);
    }

    @NotNull
    private static BitSet calcAmbiguousSupers(Symbol.ClassSymbol[] classSymbols) {
        BitSet ambiguousSupers = new BitSet();
        for (Symbol.ClassSymbol symbol : classSymbols) {
            if (symbol.isHierarchyIncomplete() || !symbol.hasAmbiguousSupers()) continue;
            ambiguousSupers.set(symbol.myAnchorId);
        }
        return ambiguousSupers;
    }

    @NotNull
    private static BitSet calcAnonymous(Symbol.ClassSymbol[] classSymbols) {
        BitSet answer = new BitSet();
        for (Symbol.ClassSymbol symbol : classSymbols) {
            if (symbol.isHierarchyIncomplete() || symbol.myShortName != 0) continue;
            answer.set(symbol.myAnchorId);
        }
        return answer;
    }

    @NotNull
    private BitSet calcCoveredFiles(Symbol.ClassSymbol[] classSymbols) {
        BitSet problematicFiles = new BitSet();
        BitSet coveredFiles = new BitSet();
        for (Symbol.ClassSymbol symbol : classSymbols) {
            int fileId = this.myClassAnchors.getFileId(symbol.myAnchorId);
            coveredFiles.set(fileId);
            if (!symbol.isHierarchyIncomplete()) continue;
            problematicFiles.set(fileId);
        }
        coveredFiles.andNot(problematicFiles);
        return coveredFiles;
    }

    private boolean isCovered(@NotNull StubClassAnchor anchor) {
        return this.myCoveredFiles.get(anchor.myFileId);
    }

    @NotNull
    public List<StubClassAnchor> getCoveredClasses() {
        return ContainerUtil.filter(this.getAllClasses(), this::isCovered);
    }

    @NotNull
    public List<StubClassAnchor> getAllClasses() {
        return IntStream.range(0, this.myClassAnchors.size()).boxed().map(this.myClassAnchors::getAnchor).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public SmartClassAnchor[] getDirectSubtypeCandidates(@NotNull PsiClass psiClass) {
        SmartClassAnchor anchor = this.findAnchor(psiClass);
        return anchor == null ? StubClassAnchor.EMPTY_ARRAY : this.getDirectSubtypeCandidates(anchor);
    }

    @Override
    @Nullable
    public SmartClassAnchor findAnchor(@NotNull PsiClass psiClass) {
        VirtualFile vFile = psiClass.getContainingFile().getVirtualFile();
        return vFile instanceof VirtualFileWithId ? this.forPsiClass(((VirtualFileWithId)vFile).getId(), psiClass) : null;
    }

    @Override
    @NotNull
    public SmartClassAnchor[] getDirectSubtypeCandidates(@NotNull SmartClassAnchor anchor) {
        int symbolId = ((StubClassAnchor)anchor).myId;
        int start = this.subtypeStart(symbolId);
        int end = this.subtypeEnd(symbolId);
        int length = end - start;
        if (length == 0) {
            return StubClassAnchor.EMPTY_ARRAY;
        }
        SmartClassAnchor[] result2 = new StubClassAnchor[length];
        for (int i2 = 0; i2 < length; ++i2) {
            result2[i2] = this.myClassAnchors.getAnchor(this.mySubtypes[start + i2]);
        }
        return result2;
    }

    @Override
    public boolean hasAmbiguousSupers(@NotNull SmartClassAnchor anchor) {
        return this.myAmbiguousSupers.get(((StubClassAnchor)anchor).myId);
    }

    @Override
    public boolean isAnonymous(@NotNull SmartClassAnchor anchor) {
        return this.myAnonymous.get(((StubClassAnchor)anchor).myId);
    }

    @Override
    @NotNull
    public GlobalSearchScope restrictToUncovered(@NotNull GlobalSearchScope scope) {
        if (this.myCoveredFiles.isEmpty()) {
            return scope;
        }
        return new DelegatingGlobalSearchScope(scope, new Object[]{this}){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 instanceof VirtualFileWithId && SingleClassHierarchy.this.myCoveredFiles.get(((VirtualFileWithId)file2).getId())) {
                    return false;
                }
                return super.contains(file2);
            }
        };
    }

    @NotNull
    private Integer[] getAnchorsFromDistinctFiles() {
        if (this.myClassAnchors.size() == 0) {
            return new Integer[0];
        }
        Integer[] result2 = new Integer[this.myClassAnchors.size()];
        result2[0] = 0;
        int i2 = 1;
        for (int classAnchor = 1; classAnchor < result2.length; ++classAnchor) {
            if (this.myClassAnchors.getFileId(classAnchor - 1) == this.myClassAnchors.getFileId(classAnchor)) continue;
            result2[i2++] = classAnchor;
        }
        return Arrays.copyOf(result2, i2);
    }

    private int[] mkByFileId() {
        Integer[] ids = this.getAnchorsFromDistinctFiles();
        Arrays.sort(ids, (a1, a2) -> Integer.compare(this.myClassAnchors.getFileId((int)a1), this.myClassAnchors.getFileId((int)a2)));
        return ArrayUtils.toPrimitive((Integer[])ids);
    }

    private void connectSubTypes(Symbol.ClassSymbol[] classSymbols) {
        int[] sizes = SingleClassHierarchy.calculateSizes(classSymbols);
        int[] starts = new int[classSymbols.length];
        int count = 0;
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            starts[i2] = count;
            count += sizes[i2];
        }
        int[] subtypes = new int[count];
        int[] filled = new int[sizes.length];
        for (int subTypeId = 0; subTypeId < classSymbols.length; ++subTypeId) {
            Symbol.ClassSymbol subType = classSymbols[subTypeId];
            for (Symbol.ClassSymbol superType : subType.rawSuperClasses()) {
                int superTypeId = superType.myAnchorId;
                subtypes[starts[superTypeId] + filled[superTypeId]] = subTypeId;
                int n = superTypeId;
                filled[n] = filled[n] + 1;
            }
        }
        this.mySubtypes = subtypes;
        this.mySubtypeStarts = starts;
    }

    private void excludeUncoveredFiles(Symbol.ClassSymbol[] classSymbols) {
        for (Symbol.ClassSymbol symbol : classSymbols) {
            if (this.myCoveredFiles.get(this.myClassAnchors.getFileId(symbol.myAnchorId))) continue;
            symbol.markHierarchyIncomplete();
        }
    }

    private static int[] calculateSizes(Symbol.ClassSymbol[] classSymbols) {
        int[] sizes = new int[classSymbols.length];
        for (Symbol.ClassSymbol subType : classSymbols) {
            for (Symbol.ClassSymbol superType : subType.rawSuperClasses()) {
                int n = superType.myAnchorId;
                sizes[n] = sizes[n] + 1;
            }
        }
        return sizes;
    }

    private int subtypeStart(int nameId) {
        return this.mySubtypeStarts[nameId];
    }

    private int subtypeEnd(int nameId) {
        return nameId + 1 >= this.mySubtypeStarts.length ? this.mySubtypes.length : this.mySubtypeStarts[nameId + 1];
    }

    private StubClassAnchor forPsiClass(int fileId, PsiClass psiClass) {
        int id = this.getFirst(fileId);
        if (id == -1) {
            return null;
        }
        while (id < this.myClassAnchors.size() && this.myClassAnchors.getFileId(id) == fileId) {
            if (psiClass.isEquivalentTo((PsiElement)this.myClassAnchors.retrieveClass(psiClass.getProject(), id))) {
                return this.myClassAnchors.getAnchor(id);
            }
            ++id;
        }
        return null;
    }

    private int getFirst(int fileId) {
        int lo = 0;
        int hi = this.myClassAnchorsByFileIds.length - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            int midFileId = this.myClassAnchors.getFileId(this.myClassAnchorsByFileIds[mid]);
            if (fileId < midFileId) {
                hi = mid - 1;
                continue;
            }
            if (fileId > midFileId) {
                lo = mid + 1;
                continue;
            }
            return this.myClassAnchorsByFileIds[mid];
        }
        return -1;
    }
}

