/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.IncompleteHierarchyException;
import com.intellij.psi.stubsHierarchy.impl.StubHierarchyConnector;
import com.intellij.psi.stubsHierarchy.impl.UnitInfo;
import com.intellij.util.BitUtil;
import gnu.trove.TIntHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class Symbol {
    int myFlags;
    final int myShortName;
    final Symbol myOwner;
    private static final Comparator<ClassSymbol> CLASS_SYMBOL_BY_NAME_COMPARATOR = (s1, s2) -> {
        int name1 = s1.myShortName;
        int name2 = s2.myShortName;
        return name1 < name2 ? -1 : (name1 == name2 ? 0 : 1);
    };

    public Symbol(int flags, Symbol owner, int name) {
        this.myFlags = flags;
        this.myOwner = owner;
        this.myShortName = name;
    }

    public int hashCode() {
        return this.myShortName;
    }

    ClassSymbol[] getMembers() {
        return ClassSymbol.EMPTY_ARRAY;
    }

    public boolean isPackage() {
        return BitUtil.isSet((int)this.myFlags, (int)1);
    }

    public boolean isClass() {
        return BitUtil.isSet((int)this.myFlags, (int)2);
    }

    public boolean isMember() {
        return BitUtil.isSet((int)this.myFlags, (int)256);
    }

    public PackageSymbol pkg() {
        Symbol sym = this;
        while (!sym.isPackage()) {
            sym = sym.myOwner;
        }
        return (PackageSymbol)sym;
    }

    public static class MemberSymbol
    extends Symbol {
        private Object myMembers = null;

        MemberSymbol(Symbol owner) {
            super(256, owner, 0);
        }

        MemberSymbol(int flags, Symbol owner, int name) {
            super(flags, owner, name);
        }

        @Override
        ClassSymbol[] getMembers() {
            ClassSymbol[] classSymbolArray;
            if (this.myMembers == null) {
                classSymbolArray = ClassSymbol.EMPTY_ARRAY;
            } else if (this.myMembers instanceof ClassSymbol) {
                ClassSymbol[] classSymbolArray2 = new ClassSymbol[1];
                classSymbolArray = classSymbolArray2;
                classSymbolArray2[0] = (ClassSymbol)this.myMembers;
            } else {
                classSymbolArray = (ClassSymbol[])this.myMembers;
            }
            return classSymbolArray;
        }

        void setMembers(List<ClassSymbol> members) {
            this.myMembers = members.isEmpty() ? null : (members.size() == 1 ? members.get(0) : MemberSymbol.toSortedArray(members));
        }

        private static ClassSymbol[] toSortedArray(List<ClassSymbol> members) {
            ClassSymbol[] array = members.toArray(new ClassSymbol[members.size()]);
            Arrays.sort(array, CLASS_SYMBOL_BY_NAME_COMPARATOR);
            return array;
        }
    }

    public static class ClassSymbol
    extends MemberSymbol {
        private static final int CONNECT_STARTED = 0x200000;
        public static final ClassSymbol[] EMPTY_ARRAY = new ClassSymbol[0];
        final int myAnchorId;
        Object mySuperClasses;
        UnitInfo myUnitInfo;

        ClassSymbol(int anchorId, int flags, Symbol owner, int name, UnitInfo unitInfo, Object supers) {
            super(flags | 2, owner, name);
            this.myAnchorId = anchorId;
            boolean incomplete = this.isHierarchyIncomplete();
            this.mySuperClasses = incomplete ? null : supers;
            this.myUnitInfo = incomplete ? null : unitInfo;
        }

        @Override
        public int hashCode() {
            return this.myAnchorId;
        }

        public String toString() {
            return String.valueOf(this.myAnchorId);
        }

        void connect(StubHierarchyConnector connector) {
            if (!this.isConnectStarted()) {
                this.myFlags = BitUtil.set((int)this.myFlags, (int)0x200000, (boolean)true);
                connector.connect(this);
            }
        }

        private boolean isConnectStarted() {
            return BitUtil.isSet((int)this.myFlags, (int)0x200000);
        }

        @Nullable
        Object getSuperClasses(StubHierarchyConnector connector) throws IncompleteHierarchyException {
            this.connect(connector);
            if (this.isHierarchyIncomplete()) {
                throw IncompleteHierarchyException.INSTANCE;
            }
            return this.mySuperClasses;
        }

        @NotNull
        ClassSymbol[] rawSuperClasses() {
            ClassSymbol[] classSymbolArray;
            assert (this.isConnectStarted());
            if (this.mySuperClasses instanceof ClassSymbol) {
                ClassSymbol[] classSymbolArray2 = new ClassSymbol[1];
                classSymbolArray = classSymbolArray2;
                classSymbolArray2[0] = (ClassSymbol)this.mySuperClasses;
            } else {
                classSymbolArray = this.mySuperClasses instanceof ClassSymbol[] ? (ClassSymbol[])this.mySuperClasses : EMPTY_ARRAY;
            }
            return classSymbolArray;
        }

        boolean isCompiled() {
            return BitUtil.isSet((int)this.myFlags, (int)128);
        }

        void markHierarchyIncomplete() {
            this.setSupers(Collections.emptySet());
            this.myFlags = BitUtil.set((int)this.myFlags, (int)512, (boolean)true);
        }

        void setSupers(Set<ClassSymbol> supers) {
            this.mySuperClasses = supers.isEmpty() ? null : (supers.size() == 1 ? supers.iterator().next() : supers.toArray(new ClassSymbol[supers.size()]));
            this.myUnitInfo = null;
        }

        boolean isHierarchyIncomplete() {
            return BitUtil.isSet((int)this.myFlags, (int)512);
        }

        boolean hasAmbiguousSupers() {
            ClassSymbol[] superClasses = this.rawSuperClasses();
            if (superClasses.length < 2) {
                return false;
            }
            TIntHashSet superNames = new TIntHashSet();
            for (ClassSymbol symbol : superClasses) {
                if (superNames.add(symbol.myShortName)) continue;
                return true;
            }
            return false;
        }
    }

    public static class PackageSymbol
    extends Symbol {
        final int myQualifiedName;

        public PackageSymbol(Symbol owner, int fullname, int name) {
            super(1, owner, name);
            this.myQualifiedName = fullname;
        }
    }
}

