/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.messages.MessageBus;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataLanguagePusher
implements FilePropertyPusher<Language> {
    public static final Key<Language> KEY = Key.create((String)"TEMPLATE_DATA_LANGUAGE");
    private static final VfsDependentEnum<String> ourLanguagesEnumerator = new VfsDependentEnum("languages", EnumeratorStringDescriptor.INSTANCE, 1);
    private static final FileAttribute PERSISTENCE = new FileAttribute("template_language", 2, true);

    public void initExtra(@NotNull Project project2, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
    }

    @NotNull
    public Key<Language> getFileDataKey() {
        return KEY;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    @NotNull
    public Language getDefaultValue() {
        return Language.ANY;
    }

    @Nullable
    public Language getImmediateValue(@NotNull Project project2, @Nullable VirtualFile file2) {
        return (Language)TemplateDataLanguageMappings.getInstance(project2).getImmediateMapping(file2);
    }

    @Nullable
    public Language getImmediateValue(@NotNull Module module2) {
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file2) {
        return true;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project2, @NotNull VirtualFile fileOrDir, @NotNull Language value2) throws IOException {
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                int oldLanguage = DataInputOutputUtil.readINT((DataInput)iStream);
                String oldLanguageId = ourLanguagesEnumerator.getById(oldLanguage);
                if (value2.getID().equals(oldLanguageId)) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        if (value2 != Language.ANY || iStream != null) {
            DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
            DataInputOutputUtil.writeINT((DataOutput)oStream, (int)ourLanguagesEnumerator.getId(value2.getID()));
            oStream.close();
            PushedFilePropertiesUpdater.getInstance((Project)project2).filePropertiesChanged(fileOrDir, Conditions.alwaysTrue());
        }
    }

    public void afterRootsChanged(@NotNull Project project2) {
    }
}

