/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.text;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BlockSupport {
    public static final Key<Boolean> DO_NOT_REPARSE_INCREMENTALLY = Key.create((String)"DO_NOT_REPARSE_INCREMENTALLY");
    public static final Key<Pair<ASTNode, CharSequence>> TREE_TO_BE_REPARSED = Key.create((String)"TREE_TO_BE_REPARSED");
    public static final int INCREMENTAL_REPARSE_DEPTH_LIMIT = Registry.intValue((String)"psi.incremental.reparse.depth.limit");
    public static final Key<Boolean> TREE_DEPTH_LIMIT_EXCEEDED = Key.create((String)"TREE_IS_TOO_DEEP");

    public static BlockSupport getInstance(Project project2) {
        return (BlockSupport)ServiceManager.getService((Project)project2, BlockSupport.class);
    }

    public abstract void reparseRange(@NotNull PsiFile var1, int var2, int var3, @NonNls @NotNull CharSequence var4) throws IncorrectOperationException;

    @NotNull
    public abstract DiffLog reparseRange(@NotNull PsiFile var1, @NotNull FileASTNode var2, @NotNull TextRange var3, @NotNull CharSequence var4, @NotNull ProgressIndicator var5, @NotNull CharSequence var6) throws IncorrectOperationException;

    public static boolean isTooDeep(UserDataHolder element) {
        return element != null && Boolean.TRUE.equals(element.getUserData(TREE_DEPTH_LIMIT_EXCEEDED));
    }

    public static class ReparsedSuccessfullyException
    extends RuntimeException
    implements ControlFlowException {
        private final DiffLog myDiffLog;

        public ReparsedSuccessfullyException(@NotNull DiffLog diffLog) {
            this.myDiffLog = diffLog;
        }

        @NotNull
        public DiffLog getDiffLog() {
            return this.myDiffLog;
        }

        @Override
        @NotNull
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

