/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiMatcherExpression;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class PsiMatchers {
    private PsiMatchers() {
    }

    @NotNull
    public static PsiMatcherExpression hasName(final @NotNull String name) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasText(final @NotNull String text) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element.getTextLength() != text.length()) {
                    return Boolean.FALSE;
                }
                return text.equals(element.getText());
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasText(final String ... texts) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                String text = element.getText();
                return ArrayUtil.find((Object[])texts, (Object)text) != -1;
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final @NotNull Class<?> aClass) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (aClass.isAssignableFrom(element.getClass())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final Class ... classes2) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                for (Class aClass : classes2) {
                    if (!aClass.isAssignableFrom(element.getClass())) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }
}

