/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;

public class InResolveScopeWeigher
extends ProximityWeigher {
    private static final NotNullLazyKey<GlobalSearchScope, ProximityLocation> PLACE_SCOPE = NotNullLazyKey.create((String)"placeScope", location -> {
        PsiElement position = location.getPosition();
        return position == null ? GlobalSearchScope.EMPTY_SCOPE : position.getResolveScope();
    });

    @Override
    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        VirtualFile elementFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        return Boolean.valueOf(elementFile != null && ((GlobalSearchScope)PLACE_SCOPE.getValue((UserDataHolder)location)).contains(elementFile));
    }
}

