/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePlatformRefactoringAction
extends BaseRefactoringAction {
    private Boolean myHidden = null;
    private final Condition<RefactoringSupportProvider> myCondition = provider2 -> this.getRefactoringHandler((RefactoringSupportProvider)provider2) != null;

    public BasePlatformRefactoringAction() {
        LanguageRefactoringSupport.INSTANCE.addListener((ExtensionPointListener)new ExtensionPointListener<RefactoringSupportProvider>(){

            public void extensionAdded(@NotNull RefactoringSupportProvider extension, @Nullable PluginDescriptor pluginDescriptor) {
                BasePlatformRefactoringAction.this.myHidden = null;
            }

            public void extensionRemoved(@NotNull RefactoringSupportProvider extension, @Nullable PluginDescriptor pluginDescriptor) {
                BasePlatformRefactoringAction.this.myHidden = null;
            }
        });
    }

    @Override
    protected final RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        Language[] languages;
        RefactoringActionHandler handler2;
        RefactoringActionHandler handler3;
        RefactoringActionHandler handler4;
        PsiElement element = null;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (editor != null && file2 != null && (element = BasePlatformRefactoringAction.getElementAtCaret(editor, file2)) != null && (handler4 = this.getHandler(element.getLanguage(), element)) != null) {
            return handler4;
        }
        PsiElement referenced = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (referenced != null && (handler3 = this.getHandler(referenced.getLanguage(), referenced)) != null) {
            return handler3;
        }
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (psiElements != null && psiElements.length > 1 && (handler2 = this.getHandler(psiElements[0].getLanguage(), psiElements[0])) != null && this.isEnabledOnElements(psiElements)) {
            return handler2;
        }
        if (element == null) {
            element = referenced;
        }
        if ((languages = (Language[])LangDataKeys.CONTEXT_LANGUAGES.getData(dataContext)) != null) {
            for (Language language : languages) {
                RefactoringActionHandler handler5 = this.getHandler(language, element);
                if (handler5 == null) continue;
                return handler5;
            }
        }
        return null;
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull Language language, PsiElement element) {
        List providers = LanguageRefactoringSupport.INSTANCE.allForLanguage(language);
        if (providers.isEmpty()) {
            return null;
        }
        if (element == null) {
            return this.getRefactoringHandler((RefactoringSupportProvider)providers.get(0));
        }
        for (RefactoringSupportProvider provider2 : providers) {
            if (!provider2.isAvailable(element)) continue;
            return this.getRefactoringHandler(provider2, element);
        }
        return null;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        return this.getHandler(context) != null;
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        List providers = LanguageRefactoringSupport.INSTANCE.allForLanguage(language);
        return ContainerUtil.find((Iterable)providers, this.myCondition) != null;
    }

    @Override
    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements.length > 0) {
            Language language = elements[0].getLanguage();
            RefactoringActionHandler handler2 = this.getHandler(language, elements[0]);
            return handler2 instanceof ElementsHandler && ((ElementsHandler)handler2).isEnabledOnElements(elements);
        }
        return false;
    }

    @Nullable
    protected abstract RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider var1);

    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider2, PsiElement element) {
        return this.getRefactoringHandler(provider2);
    }

    @Override
    protected boolean isHidden() {
        if (this.myHidden == null) {
            this.myHidden = this.calcHidden();
        }
        return this.myHidden;
    }

    private boolean calcHidden() {
        for (Language l : Language.getRegisteredLanguages()) {
            if (!this.isAvailableForLanguage(l)) continue;
            return false;
        }
        return true;
    }
}

