/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BasePlatformRefactoringAction;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSignatureAction
extends BasePlatformRefactoringAction {
    public ChangeSignatureAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        return elements.length == 1 && ChangeSignatureAction.findTargetMember(elements[0]) != null;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        PsiElement targetMember = ChangeSignatureAction.findTargetMember(element);
        if (targetMember == null) {
            ChangeSignatureHandler targetHandler = ChangeSignatureAction.getChangeSignatureHandler(file2.getLanguage());
            return targetHandler != null;
        }
        ChangeSignatureHandler targetHandler = ChangeSignatureAction.getChangeSignatureHandler(targetMember.getLanguage());
        return targetHandler != null;
    }

    @Nullable
    private static PsiElement findTargetMember(@Nullable PsiElement element) {
        PsiElement targetMember;
        if (element == null) {
            return null;
        }
        ChangeSignatureHandler fileHandler = ChangeSignatureAction.getChangeSignatureHandler(element.getLanguage());
        if (fileHandler != null && (targetMember = fileHandler.findTargetMember(element)) != null) {
            return targetMember;
        }
        PsiReference reference = element.getReference();
        if (reference == null && element instanceof PsiNameIdentifierOwner) {
            return element;
        }
        if (reference != null) {
            return reference.resolve();
        }
        return null;
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider2) {
        return provider2.getChangeSignatureHandler();
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider2, final PsiElement element) {
        abstract class ContextAwareChangeSignatureHandler
        implements RefactoringActionHandler,
        ContextAwareActionHandler {
            ContextAwareChangeSignatureHandler() {
            }
        }
        return new ContextAwareChangeSignatureHandler(){
            {
            }

            public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
                return ChangeSignatureAction.findTargetMember(element) != null;
            }

            public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                PsiElement targetMember = ChangeSignatureAction.findTargetMember(element);
                if (targetMember == null) {
                    String notFoundMessage;
                    ChangeSignatureHandler handler2 = ChangeSignatureAction.getChangeSignatureHandler(file2.getLanguage());
                    if (handler2 != null && (notFoundMessage = handler2.getTargetNotFoundMessage()) != null) {
                        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)notFoundMessage, (String)ChangeSignatureHandler.REFACTORING_NAME, null);
                    }
                    return;
                }
                ChangeSignatureHandler handler3 = ChangeSignatureAction.getChangeSignatureHandler(targetMember.getLanguage());
                if (handler3 == null) {
                    return;
                }
                handler3.invoke(project2, new PsiElement[]{targetMember}, dataContext);
            }

            public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
                if (elements.length != 1) {
                    return;
                }
                PsiElement targetMember = ChangeSignatureAction.findTargetMember(elements[0]);
                if (targetMember == null) {
                    return;
                }
                ChangeSignatureHandler handler2 = ChangeSignatureAction.getChangeSignatureHandler(targetMember.getLanguage());
                if (handler2 == null) {
                    return;
                }
                handler2.invoke(project2, new PsiElement[]{targetMember}, dataContext);
            }
        };
    }

    @Nullable
    private static ChangeSignatureHandler getChangeSignatureHandler(Language language) {
        return ((RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(language)).getChangeSignatureHandler();
    }
}

