/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.ide.TitledHandler;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BasePlatformRefactoringAction;
import com.intellij.refactoring.lang.LanguageExtractInclude;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractIncludeAction
extends BasePlatformRefactoringAction {
    @Override
    public boolean isAvailableInEditorOnly() {
        return true;
    }

    @Override
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        return false;
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        RefactoringActionHandler handler2 = this.getHandler(e.getDataContext());
        if (handler2 instanceof TitledHandler) {
            e.getPresentation().setText(((TitledHandler)handler2).getActionTitle());
        } else {
            e.getPresentation().setText("Include File...");
        }
    }

    @Override
    protected boolean isAvailableForFile(PsiFile file2) {
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        return LanguageExtractInclude.INSTANCE.forLanguage(baseLanguage) != null;
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull Language language, PsiElement element) {
        RefactoringActionHandler handler2 = super.getHandler(language, element);
        if (handler2 != null) {
            return handler2;
        }
        return element == null ? null : ExtractIncludeAction.getHandler(element);
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider2) {
        return null;
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider2, PsiElement element) {
        return ExtractIncludeAction.getHandler(element);
    }

    @Nullable
    private static RefactoringActionHandler getHandler(@NotNull PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return null;
        }
        return (RefactoringActionHandler)LanguageExtractInclude.INSTANCE.forLanguage(file2.getViewProvider().getBaseLanguage());
    }
}

