/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderHandler;
import org.jetbrains.annotations.NotNull;

public class ReplaceConstructorWithBuilderAction
extends BaseRefactoringAction {
    @Override
    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAt = file2.findElementAt(offset);
        PsiClass psiClass = ReplaceConstructorWithBuilderHandler.getParentNamedClass(elementAt);
        return psiClass != null && psiClass.getConstructors().length > 0 && !psiClass.isEnum();
    }

    @Override
    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        return false;
    }

    @Override
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        return new ReplaceConstructorWithBuilderHandler();
    }
}

