/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.JavaTargetElementEvaluator;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChangeSignatureHandler
implements ChangeSignatureHandler {
    private static final Logger LOG = Logger.getInstance(JavaChangeSignatureHandler.class);

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = this.findTargetMember(file2, editor);
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        JavaChangeSignatureHandler.invokeOnElement(project2, editor, element);
    }

    private static void invokeOnElement(Project project2, @Nullable Editor editor, PsiElement element) {
        if (element instanceof PsiMethod && ((PsiMethod)element).getNameIdentifier() != null) {
            JavaChangeSignatureHandler.invoke((PsiMethod)element, project2, editor);
        } else if (element instanceof PsiClass) {
            JavaChangeSignatureHandler.invoke((PsiClass)element, editor);
        } else {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.changeSignature");
        }
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        if (elements.length != 1) {
            return;
        }
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        JavaChangeSignatureHandler.invokeOnElement(project2, editor, elements[0]);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name");
    }

    private static void invoke(PsiMethod method2, Project project2, @Nullable Editor editor) {
        PsiMethod newMethod = SuperMethodWarningUtil.checkSuperMethod(method2, RefactoringBundle.message((String)"to.refactor"));
        if (newMethod == null) {
            return;
        }
        if (!newMethod.equals(method2)) {
            ChangeSignatureUtil.invokeChangeSignatureOn(newMethod, project2);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)method2)) {
            return;
        }
        PsiClass containingClass = method2.getContainingClass();
        PsiReferenceExpression refExpr = editor != null ? JavaTargetElementEvaluator.findReferenceExpression(editor) : null;
        boolean allowDelegation = containingClass != null && (!containingClass.isInterface() || PsiUtil.isLanguageLevel8OrHigher((PsiElement)containingClass));
        InplaceChangeSignature inplaceChangeSignature = editor != null ? InplaceChangeSignature.getCurrentRefactoring(editor) : null;
        ChangeInfo initialChange = inplaceChangeSignature != null ? inplaceChangeSignature.getStableChange() : null;
        boolean isInplace = Registry.is((String)"inplace.change.signature") && editor != null && editor.getSettings().isVariableInplaceRenameEnabled() && (initialChange == null || initialChange.getMethod() != method2) && refExpr == null;
        PsiIdentifier nameIdentifier = method2.getNameIdentifier();
        LOG.assertTrue(nameIdentifier != null);
        if (isInplace) {
            CommandProcessor.getInstance().executeCommand(project2, () -> new InplaceChangeSignature(project2, editor, (PsiElement)nameIdentifier), REFACTORING_NAME, null);
        } else {
            JavaMethodDescriptor methodDescriptor = new JavaMethodDescriptor(method2);
            if (initialChange != null) {
                final JavaChangeInfo currentInfo = (JavaChangeInfo)inplaceChangeSignature.getCurrentInfo();
                if (currentInfo != null) {
                    methodDescriptor = new JavaMethodDescriptor(method2){

                        @Override
                        public String getName() {
                            return currentInfo.getNewName();
                        }

                        @Override
                        public List<ParameterInfoImpl> getParameters() {
                            return Arrays.asList((ParameterInfoImpl[])currentInfo.getNewParameters());
                        }

                        @Override
                        public String getVisibility() {
                            return currentInfo.getNewVisibility();
                        }

                        @Override
                        public int getParametersCount() {
                            return currentInfo.getNewParameters().length;
                        }

                        @Override
                        @Nullable
                        public String getReturnTypeText() {
                            return currentInfo.getNewReturnType().getTypeText();
                        }
                    };
                }
                inplaceChangeSignature.cancel();
            }
            JavaChangeSignatureDialog dialog2 = new JavaChangeSignatureDialog(project2, methodDescriptor, allowDelegation, (PsiElement)(refExpr == null ? method2 : refExpr));
            dialog2.show();
        }
    }

    private static void invoke(PsiClass aClass, Editor editor) {
        PsiTypeParameterList typeParameterList = aClass.getTypeParameterList();
        Project project2 = aClass.getProject();
        if (typeParameterList == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"changeClassSignature.no.type.parameters"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"change.class.signature.dialog");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)aClass)) {
            return;
        }
        ChangeClassSignatureDialog dialog2 = new ChangeClassSignatureDialog(aClass, true);
        dialog2.show();
    }

    @Nullable
    public PsiElement findTargetMember(PsiFile file2, Editor editor) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        return this.findTargetMember(element);
    }

    public PsiElement findTargetMember(PsiElement element) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiReferenceParameterList referenceParameterList;
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameterList.class) != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        }
        PsiTypeParameterList typeParameterList = (PsiTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeParameterList.class);
        if (typeParameterList != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)typeParameterList, PsiMember.class);
        }
        PsiElement elementParent = element.getParent();
        if (elementParent instanceof PsiMethod && ((PsiMethod)elementParent).getNameIdentifier() == element) {
            PsiClass containingClass = ((PsiMethod)elementParent).getContainingClass();
            if (containingClass != null && containingClass.isAnnotationType()) {
                return null;
            }
            return elementParent;
        }
        if (elementParent instanceof PsiClass && ((PsiClass)elementParent).getNameIdentifier() == element) {
            if (((PsiClass)elementParent).isAnnotationType() || ((PsiClass)elementParent).isEnum()) {
                return null;
            }
            return elementParent;
        }
        PsiCallExpression expression2 = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCallExpression.class);
        if (expression2 != null) {
            Object qualifierExpression2 = expression2 instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression() : (expression2 instanceof PsiNewExpression ? ((PsiNewExpression)expression2).getQualifier() : null);
            if (PsiTreeUtil.isAncestor((PsiElement)qualifierExpression2, (PsiElement)element, (boolean)false)) {
                PsiElement parent;
                PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)qualifierExpression2, PsiExpressionList.class);
                if (expressionList != null && (parent = expressionList.getParent()) instanceof PsiCallExpression) {
                    return ((PsiCallExpression)parent).resolveMethod();
                }
            } else {
                return expression2.resolveMethod();
            }
        }
        if ((referenceParameterList = (PsiReferenceParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiReferenceParameterList.class)) != null && (referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiJavaCodeReferenceElement.class)) != null) {
            PsiElement resolved = referenceElement.resolve();
            if (resolved instanceof PsiClass) {
                return resolved;
            }
            if (resolved instanceof PsiMethod) {
                return resolved;
            }
        }
        return null;
    }
}

