/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.inplace.ApplyChangeSignatureAction;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetectors;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ChangeSignaturePassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public ChangeSignaturePassFactory(Project project2, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project2);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, true, -1);
    }

    @Override
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(file2.getLanguage());
        if (detector == null) {
            return null;
        }
        return new ChangeSignaturePass(file2.getProject(), file2, editor);
    }

    private static class ChangeSignaturePass
    extends TextEditorHighlightingPass {
        @NonNls
        private static final String SIGNATURE_SHOULD_BE_POSSIBLY_CHANGED = "Signature change was detected";
        private final Project myProject;
        private final PsiFile myFile;
        private final Editor myEditor;

        public ChangeSignaturePass(Project project2, PsiFile file2, Editor editor) {
            super(project2, editor.getDocument(), true);
            this.myProject = project2;
            this.myFile = file2;
            this.myEditor = editor;
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
        }

        @Override
        public void doApplyInformationToEditor() {
            HighlightInfo info = null;
            InplaceChangeSignature currentRefactoring = InplaceChangeSignature.getCurrentRefactoring(this.myEditor);
            if (currentRefactoring != null) {
                ChangeInfo changeInfo = currentRefactoring.getStableChange();
                PsiElement element = changeInfo.getMethod();
                int offset = this.myEditor.getCaretModel().getOffset();
                if (element == null || !element.isValid()) {
                    return;
                }
                TextRange elementTextRange = element.getTextRange();
                if (elementTextRange == null || !elementTextRange.contains(offset)) {
                    return;
                }
                LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(changeInfo.getLanguage());
                TextRange range = detector.getHighlightingRange(changeInfo);
                TextAttributes attributes = new TextAttributes(null, null, this.myEditor.getColorsScheme().getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getEffectColor(), null, 0);
                HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.INFORMATION).range(range);
                builder.textAttributes(attributes);
                builder.descriptionAndTooltip(SIGNATURE_SHOULD_BE_POSSIBLY_CHANGED);
                info = builder.createUnconditionally();
                QuickFixAction.registerQuickFixAction(info, (IntentionAction)new ApplyChangeSignatureAction(currentRefactoring.getInitialName()));
            }
            List<HighlightInfo> infos = info != null ? Collections.singletonList(info) : Collections.emptyList();
            UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myFile.getTextLength(), infos, this.getColorsScheme(), this.getId());
        }
    }
}

