/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.convertToInstanceMethod;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ConvertToInstanceMethodHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodHandler");
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"convert.to.instance.method.title");

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file2.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (!(element instanceof PsiMethod)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.convertToInstanceMethod");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MakeMethodStaticHandler invoked");
        }
        this.invoke(project2, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (elements.length != 1 || !(elements[0] instanceof PsiMethod)) {
            return;
        }
        PsiMethod method2 = (PsiMethod)elements[0];
        if (!method2.hasModifierProperty("static")) {
            String message2 = RefactoringBundle.message((String)"convertToInstanceMethod.method.is.not.static", (Object[])new Object[]{method2.getName()});
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.convertToInstanceMethod");
            return;
        }
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        ArrayList<PsiParameter> suitableParameters = new ArrayList<PsiParameter>();
        boolean classTypesFound = false;
        boolean resolvableClassesFound = false;
        boolean classesInProjectFound = false;
        for (PsiParameter parameter : parameters2) {
            PsiType type2 = parameter.getType();
            if (!(type2 instanceof PsiClassType)) continue;
            classTypesFound = true;
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            if (psiClass == null || psiClass instanceof PsiTypeParameter) continue;
            resolvableClassesFound = true;
            boolean inProject = method2.getManager().isInProject((PsiElement)psiClass);
            if (!inProject) continue;
            classesInProjectFound = true;
            suitableParameters.add(parameter);
        }
        if (suitableParameters.isEmpty()) {
            String message3 = null;
            if (!classTypesFound) {
                message3 = RefactoringBundle.message((String)"convertToInstanceMethod.no.parameters.with.reference.type");
            } else if (!resolvableClassesFound) {
                message3 = RefactoringBundle.message((String)"convertToInstanceMethod.all.reference.type.parametres.have.unknown.types");
            } else if (!classesInProjectFound) {
                message3 = RefactoringBundle.message((String)"convertToInstanceMethod.all.reference.type.parameters.are.not.in.project");
            }
            LOG.assertTrue(message3 != null);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)message3), (String)REFACTORING_NAME, (String)"refactoring.convertToInstanceMethod");
            return;
        }
        new ConvertToInstanceMethodDialog(method2, suitableParameters.toArray(new PsiParameter[suitableParameters.size()])).show();
    }
}

