/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.encapsulateFields;

import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldHelper;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldUsageInfo;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDescriptor;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsViewDescriptor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncapsulateFieldsProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.encapsulateFields.EncapsulateFieldsProcessor");
    private PsiClass myClass;
    @NotNull
    private final EncapsulateFieldsDescriptor myDescriptor;
    private final FieldDescriptor[] myFieldDescriptors;
    private HashMap<String, PsiMethod> myNameToGetter;
    private HashMap<String, PsiMethod> myNameToSetter;

    public EncapsulateFieldsProcessor(Project project2, @NotNull EncapsulateFieldsDescriptor descriptor) {
        super(project2);
        this.myDescriptor = descriptor;
        this.myFieldDescriptors = descriptor.getSelectedFields();
        this.myClass = descriptor.getTargetClass();
    }

    public static void setNewFieldVisibility(PsiField field, EncapsulateFieldsDescriptor descriptor) {
        try {
            if (descriptor.getFieldsVisibility() != null) {
                field.normalizeDeclaration();
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)descriptor.getFieldsVisibility(), (boolean)true);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.encapsulateFields";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        ArrayList<PsiField> fields = new ArrayList<PsiField>();
        for (FieldDescriptor fieldDescriptor : this.myFieldDescriptors) {
            fields.add(fieldDescriptor.getField());
        }
        data.addElements(fields);
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        RefactoringEventData data = new RefactoringEventData();
        ArrayList elements = new ArrayList();
        if (this.myNameToGetter != null) {
            elements.addAll(this.myNameToGetter.values());
        }
        if (this.myNameToSetter != null) {
            elements.addAll(this.myNameToSetter.values());
        }
        data.addElements(elements);
        return data;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        FieldDescriptor[] fields = new FieldDescriptor[this.myFieldDescriptors.length];
        System.arraycopy(this.myFieldDescriptors, 0, fields, 0, this.myFieldDescriptors.length);
        return new EncapsulateFieldsViewDescriptor(fields);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"encapsulate.fields.command.name", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass)});
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        UsageInfo[] infos;
        MultiMap conflicts = new MultiMap();
        this.checkExistingMethods((MultiMap<PsiElement, String>)conflicts, true);
        this.checkExistingMethods((MultiMap<PsiElement, String>)conflicts, false);
        Collection classes2 = ClassInheritorsSearch.search((PsiClass)this.myClass).findAll();
        for (FieldDescriptor fieldDescriptor : this.myFieldDescriptors) {
            HashSet<PsiMethod> setters = new HashSet<PsiMethod>();
            HashSet<PsiMethod> getters = new HashSet<PsiMethod>();
            for (PsiClass aClass : classes2) {
                PsiMethod setterOverrider;
                PsiMethod getterOverrider;
                PsiMethod psiMethod = getterOverrider = this.myDescriptor.isToEncapsulateGet() ? aClass.findMethodBySignature(fieldDescriptor.getGetterPrototype(), false) : null;
                if (getterOverrider != null) {
                    getters.add(getterOverrider);
                }
                if ((setterOverrider = this.myDescriptor.isToEncapsulateSet() ? aClass.findMethodBySignature(fieldDescriptor.getSetterPrototype(), false) : null) == null) continue;
                setters.add(setterOverrider);
            }
            if (getters.isEmpty() && setters.isEmpty()) continue;
            PsiField field = fieldDescriptor.getField();
            block2: for (PsiReference reference : ReferencesSearch.search((PsiElement)field)) {
                PsiElement place = reference.getElement();
                if (!(place instanceof PsiReferenceExpression)) continue;
                PsiExpression qualifierExpression2 = ((PsiReferenceExpression)place).getQualifierExpression();
                PsiClass ancestor = qualifierExpression2 == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class, (boolean)false) : PsiUtil.resolveClassInType((PsiType)qualifierExpression2.getType());
                boolean isGetter = !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)place));
                for (PsiMethod overridden : isGetter ? getters : setters) {
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)this.myClass, (PsiClass)ancestor, (boolean)true)) continue;
                    conflicts.putValue((Object)overridden, (Object)("There is already a " + RefactoringUIUtil.getDescription((PsiElement)overridden, true) + " which would hide generated " + (isGetter ? "getter" : "setter") + " for " + place.getText()));
                    continue block2;
                }
            }
        }
        for (UsageInfo info : infos = (UsageInfo[])refUsages.get()) {
            PsiElement parent;
            PsiElement element = info.getElement();
            if (element == null || !PsiUtil.isIncrementDecrementOperation((PsiElement)(parent = element.getParent())) || parent.getParent() instanceof PsiExpressionStatement) continue;
            conflicts.putValue((Object)parent, (Object)"Unable to proceed with postfix/prefix expression when it's result type is used");
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, infos);
    }

    private void checkExistingMethods(MultiMap<PsiElement, String> conflicts, boolean isGetter) {
        if (isGetter ? !this.myDescriptor.isToEncapsulateGet() : !this.myDescriptor.isToEncapsulateSet()) {
            return;
        }
        for (FieldDescriptor descriptor : this.myFieldDescriptors) {
            PsiMethod prototype = isGetter ? descriptor.getGetterPrototype() : descriptor.getSetterPrototype();
            PsiType prototypeReturnType = prototype.getReturnType();
            PsiMethod existing = this.myClass.findMethodBySignature(prototype, true);
            if (existing != null) {
                PsiType returnType = existing.getReturnType();
                if (RefactoringUtil.equivalentTypes(prototypeReturnType, returnType, this.myClass.getManager())) continue;
                String descr = PsiFormatUtil.formatMethod((PsiMethod)existing, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)259, (int)2);
                String message2 = isGetter ? RefactoringBundle.message((String)"encapsulate.fields.getter.exists", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)descr), CommonRefactoringUtil.htmlEmphasize((String)prototype.getName())}) : RefactoringBundle.message((String)"encapsulate.fields.setter.exists", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)descr), CommonRefactoringUtil.htmlEmphasize((String)prototype.getName())});
                conflicts.putValue((Object)existing, (Object)message2);
                continue;
            }
            block1: for (PsiClass containingClass = this.myClass.getContainingClass(); containingClass != null && existing == null; containingClass = containingClass.getContainingClass()) {
                existing = containingClass.findMethodBySignature(prototype, true);
                if (existing == null) continue;
                for (PsiReference reference : ReferencesSearch.search((PsiElement)existing)) {
                    PsiExpression qualifierExpression2;
                    PsiClass inheritor;
                    PsiElement place = reference.getElement();
                    if (!(place instanceof PsiReferenceExpression) || !InheritanceUtil.isInheritorOrSelf((PsiClass)(inheritor = (qualifierExpression2 = ((PsiReferenceExpression)place).getQualifierExpression()) == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class, (boolean)false) : PsiUtil.resolveClassInType((PsiType)qualifierExpression2.getType())), (PsiClass)this.myClass, (boolean)true)) continue;
                    conflicts.putValue((Object)existing, (Object)("There is already a " + RefactoringUIUtil.getDescription((PsiElement)existing, true) + " which would be hidden by generated " + (isGetter ? "getter" : "setter")));
                    continue block1;
                }
            }
        }
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList array = ContainerUtil.newArrayList();
        for (FieldDescriptor fieldDescriptor : this.myFieldDescriptors) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)fieldDescriptor.getField())) {
                EncapsulateFieldUsageInfo usageInfo;
                EncapsulateFieldHelper helper;
                PsiElement element = reference.getElement();
                if (element == null || (helper = EncapsulateFieldHelper.getHelper((Language)element.getLanguage())) == null || (usageInfo = helper.createUsage(this.myDescriptor, fieldDescriptor, reference)) == null) continue;
                array.add(usageInfo);
            }
        }
        EncapsulateFieldUsageInfo[] usageInfos = array.toArray(new EncapsulateFieldUsageInfo[array.size()]);
        return UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        LOG.assertTrue(elements.length == this.myFieldDescriptors.length);
        for (int idx = 0; idx < elements.length; ++idx) {
            PsiElement element = elements[idx];
            LOG.assertTrue(element instanceof PsiField);
            this.myFieldDescriptors[idx].refreshField((PsiField)element);
        }
        this.myClass = this.myFieldDescriptors[0].getField().getContainingClass();
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        this.updateFieldVisibility();
        this.generateAccessors();
        this.processUsagesPerFile(usages);
    }

    private void updateFieldVisibility() {
        if (this.myDescriptor.getFieldsVisibility() == null) {
            return;
        }
        for (FieldDescriptor descriptor : this.myFieldDescriptors) {
            EncapsulateFieldsProcessor.setNewFieldVisibility(descriptor.getField(), this.myDescriptor);
        }
    }

    private void generateAccessors() {
        this.myNameToGetter = new HashMap();
        this.myNameToSetter = new HashMap();
        for (FieldDescriptor fieldDescriptor : this.myFieldDescriptors) {
            PsiMethod prototype;
            DocCommentPolicy commentPolicy = new DocCommentPolicy(this.myDescriptor.getJavadocPolicy());
            PsiField field = fieldDescriptor.getField();
            PsiDocComment docComment = field.getDocComment();
            if (this.myDescriptor.isToEncapsulateGet()) {
                prototype = fieldDescriptor.getGetterPrototype();
                assert (prototype != null);
                PsiMethod getter = this.addOrChangeAccessor(prototype, this.myNameToGetter);
                if (docComment != null) {
                    PsiDocComment getterJavadoc = (PsiDocComment)getter.addBefore((PsiElement)docComment, getter.getFirstChild());
                    commentPolicy.processNewJavaDoc((PsiComment)getterJavadoc);
                }
            }
            if (this.myDescriptor.isToEncapsulateSet() && !field.hasModifierProperty("final")) {
                prototype = fieldDescriptor.getSetterPrototype();
                assert (prototype != null);
                this.addOrChangeAccessor(prototype, this.myNameToSetter);
            }
            if (docComment == null) continue;
            commentPolicy.processOldJavaDoc((PsiComment)docComment);
        }
    }

    private void processUsagesPerFile(UsageInfo[] usages) {
        HashMap usagesInFiles = new HashMap();
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            PsiFile file2 = element.getContainingFile();
            ArrayList<EncapsulateFieldUsageInfo> usagesInFile = (ArrayList<EncapsulateFieldUsageInfo>)usagesInFiles.get(file2);
            if (usagesInFile == null) {
                usagesInFile = new ArrayList<EncapsulateFieldUsageInfo>();
                usagesInFiles.put(file2, usagesInFile);
            }
            usagesInFile.add((EncapsulateFieldUsageInfo)usage);
        }
        for (List usageInfos : usagesInFiles.values()) {
            EncapsulateFieldUsageInfo[] infos = usageInfos.toArray(new EncapsulateFieldUsageInfo[usageInfos.size()]);
            CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])infos);
            for (EncapsulateFieldUsageInfo info : infos) {
                PsiElement element = info.getElement();
                if (element == null) continue;
                EncapsulateFieldHelper helper = EncapsulateFieldHelper.getHelper((Language)element.getLanguage());
                helper.processUsage(info, this.myDescriptor, (PsiMethod)this.myNameToSetter.get((Object)info.getFieldDescriptor().getSetterName()), (PsiMethod)this.myNameToGetter.get((Object)info.getFieldDescriptor().getGetterName()));
            }
        }
    }

    private PsiMethod addOrChangeAccessor(PsiMethod prototype, HashMap<String, PsiMethod> nameToAncestor) {
        PsiMethod existing;
        PsiMethod result2 = existing = this.myClass.findMethodBySignature(prototype, false);
        try {
            if (existing == null) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)prototype, (String)this.myDescriptor.getAccessorsVisibility(), (boolean)true);
                result2 = (PsiMethod)this.myClass.add((PsiElement)prototype);
            }
            nameToAncestor.put((Object)prototype.getName(), (Object)result2);
            return result2;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

