/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ExtractSuperClassUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil");
    public static final String REFACTORING_EXTRACT_SUPER_ID = "refactoring.extractSuper";

    private ExtractSuperClassUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiClass extractSuperClass(Project project2, PsiDirectory targetDirectory, String superclassName, PsiClass subclass, MemberInfo[] selectedMemberInfos, DocCommentPolicy javaDocPolicy) throws IncorrectOperationException {
        ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(REFACTORING_EXTRACT_SUPER_ID, ExtractSuperClassUtil.createBeforeData(subclass, selectedMemberInfos));
        PsiClass superclass = JavaDirectoryService.getInstance().createClass(targetDirectory, superclassName);
        try {
            PsiModifierList superClassModifierList = superclass.getModifierList();
            assert (superClassModifierList != null);
            superClassModifierList.setModifierProperty("final", false);
            PsiReferenceList subClassExtends = subclass.getExtendsList();
            if (subClassExtends != null) {
                ExtractSuperClassUtil.copyPsiReferenceList(subClassExtends, superclass.getExtendsList());
            } else if (subclass instanceof PsiAnonymousClass) {
                PsiJavaCodeReferenceElement classReference2 = ((PsiAnonymousClass)subclass).getBaseClassReference();
                PsiElement baseClass = classReference2.resolve();
                if (baseClass instanceof PsiClass && ((PsiClass)baseClass).isInterface()) {
                    superclass.getImplementsList().add((PsiElement)classReference2);
                } else {
                    superclass.getExtendsList().add((PsiElement)classReference2);
                }
            }
            PsiMethod[] constructors = ExtractSuperClassUtil.getCalledBaseConstructors(subclass);
            if (constructors.length > 0) {
                ExtractSuperClassUtil.createConstructorsByPattern(project2, superclass, constructors);
            }
            if (subClassExtends != null) {
                ExtractSuperClassUtil.clearPsiReferenceList(subclass.getExtendsList());
            }
            PsiJavaCodeReferenceElement ref = ExtractSuperClassUtil.createExtendingReference(superclass, subclass, selectedMemberInfos);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
            if (subClassExtends != null) {
                codeStyleManager.reformat(subclass.getExtendsList().add((PsiElement)ref));
            } else if (subclass instanceof PsiAnonymousClass) {
                codeStyleManager.reformat(((PsiAnonymousClass)subclass).getBaseClassReference().replace((PsiElement)ref));
            }
            PullUpProcessor pullUpHelper = new PullUpProcessor(subclass, superclass, selectedMemberInfos, javaDocPolicy);
            pullUpHelper.moveMembersToBase();
            pullUpHelper.moveFieldInitializations();
            Collection<MethodSignature> toImplement = OverrideImplementExploreUtil.getMethodSignaturesToImplement(superclass);
            if (!toImplement.isEmpty()) {
                superClassModifierList.setModifierProperty("abstract", true);
            }
            PsiClass psiClass = superclass;
            return psiClass;
        }
        finally {
            ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(REFACTORING_EXTRACT_SUPER_ID, ExtractSuperClassUtil.createAfterData(superclass));
        }
    }

    private static void createConstructorsByPattern(Project project2, PsiClass superclass, PsiMethod[] patternConstructors) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project2);
        for (PsiMethod baseConstructor : patternConstructors) {
            PsiMethod constructor = (PsiMethod)superclass.add((PsiElement)factory.createConstructor());
            PsiParameterList paramList = constructor.getParameterList();
            PsiParameter[] baseParams = baseConstructor.getParameterList().getParameters();
            StringBuilder superCallText = new StringBuilder();
            superCallText.append("super(");
            PsiClass baseClass = baseConstructor.getContainingClass();
            LOG.assertTrue(baseClass != null);
            PsiSubstitutor classSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)superclass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            for (int i2 = 0; i2 < baseParams.length; ++i2) {
                PsiParameter baseParam = baseParams[i2];
                PsiParameter newParam = (PsiParameter)paramList.add((PsiElement)factory.createParameter(baseParam.getName(), classSubstitutor.substitute(baseParam.getType())));
                if (i2 > 0) {
                    superCallText.append(",");
                }
                superCallText.append(newParam.getName());
            }
            superCallText.append(");");
            PsiStatement statement2 = factory.createStatementFromText(superCallText.toString(), null);
            statement2 = (PsiStatement)styleManager.reformat((PsiElement)statement2);
            PsiCodeBlock body2 = constructor.getBody();
            assert (body2 != null);
            body2.add((PsiElement)statement2);
            constructor.getThrowsList().replace((PsiElement)baseConstructor.getThrowsList());
        }
    }

    private static PsiMethod[] getCalledBaseConstructors(PsiClass subclass) {
        PsiMethod[] constructors;
        HashSet<PsiMethod> baseConstructors = new HashSet<PsiMethod>();
        for (PsiMethod constructor : constructors = subclass.getConstructors()) {
            PsiMethod baseConstructor;
            PsiReferenceExpression calledMethod;
            String text;
            PsiExpression expression2;
            PsiStatement first;
            PsiStatement[] statements;
            PsiCodeBlock body2 = constructor.getBody();
            if (body2 == null || (statements = body2.getStatements()).length <= 0 || !((first = statements[0]) instanceof PsiExpressionStatement) || !((expression2 = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression) || !"super".equals(text = (calledMethod = ((PsiMethodCallExpression)expression2).getMethodExpression()).getText()) || (baseConstructor = (PsiMethod)calledMethod.resolve()) == null) continue;
            baseConstructors.add(baseConstructor);
        }
        return baseConstructors.toArray(new PsiMethod[baseConstructors.size()]);
    }

    private static void clearPsiReferenceList(PsiReferenceList refList) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList.getReferenceElements()) {
            ref.delete();
        }
    }

    private static void copyPsiReferenceList(PsiReferenceList sourceList, PsiReferenceList destinationList) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        ExtractSuperClassUtil.clearPsiReferenceList(destinationList);
        for (PsiJavaCodeReferenceElement ref : refs = sourceList.getReferenceElements()) {
            destinationList.add((PsiElement)ref);
        }
    }

    public static PsiJavaCodeReferenceElement createExtendingReference(PsiClass superClass, PsiClass derivedClass, MemberInfo[] selectedMembers) throws IncorrectOperationException {
        PsiManager manager = derivedClass.getManager();
        com.intellij.util.containers.HashSet movedElements = new com.intellij.util.containers.HashSet();
        for (MemberInfo info : selectedMembers) {
            movedElements.add(info.getMember());
        }
        Condition filter = parameter -> ExtractSuperClassUtil.findTypeParameterInDerived(derivedClass, parameter.getName()) == parameter;
        PsiTypeParameterList typeParameterList = RefactoringUtil.createTypeParameterListWithUsedTypeParameters(null, (Condition<PsiTypeParameter>)filter, PsiUtilCore.toPsiElementArray((Collection)movedElements));
        PsiTypeParameterList originalTypeParameterList = superClass.getTypeParameterList();
        assert (originalTypeParameterList != null);
        PsiTypeParameterList newList = typeParameterList != null ? (PsiTypeParameterList)originalTypeParameterList.replace((PsiElement)typeParameterList) : originalTypeParameterList;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        HashMap substitutionMap = new HashMap();
        for (PsiTypeParameter parameter2 : newList.getTypeParameters()) {
            PsiTypeParameter parameterInDerived = ExtractSuperClassUtil.findTypeParameterInDerived(derivedClass, parameter2.getName());
            if (parameterInDerived == null) continue;
            substitutionMap.put(parameter2, factory.createType((PsiClass)parameterInDerived));
        }
        PsiClassType type2 = factory.createType(superClass, factory.createSubstitutor((Map)substitutionMap));
        return factory.createReferenceElementByType(type2);
    }

    @Nullable
    public static PsiTypeParameter findTypeParameterInDerived(PsiClass aClass, String name) {
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
            if (!name.equals(typeParameter.getName())) continue;
            return typeParameter;
        }
        return null;
    }

    public static void checkSuperAccessible(PsiDirectory targetDirectory, MultiMap<PsiElement, String> conflicts, PsiClass subclass) {
        VirtualFile virtualFile = subclass.getContainingFile().getVirtualFile();
        if (virtualFile != null) {
            boolean inTestSourceContent = ProjectRootManager.getInstance((Project)subclass.getProject()).getFileIndex().isInTestSourceContent(virtualFile);
            Module module2 = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)subclass.getProject());
            if (targetDirectory != null && module2 != null && !GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2, (boolean)inTestSourceContent).contains(targetDirectory.getVirtualFile())) {
                conflicts.putValue((Object)subclass, (Object)"Superclass won't be accessible in subclass");
            }
        }
    }

    public static boolean showConflicts(DialogWrapper dialog2, MultiMap<PsiElement, String> conflicts, Project project2) {
        if (!conflicts.isEmpty()) {
            ExtractSuperClassUtil.fireConflictsEvent(conflicts, project2);
            ConflictsDialog conflictsDialog = new ConflictsDialog(project2, conflicts);
            conflictsDialog.show();
            boolean ok = conflictsDialog.isOK();
            if (!ok && conflictsDialog.isShowConflicts()) {
                dialog2.close(1);
            }
            return ok;
        }
        return true;
    }

    private static void fireConflictsEvent(MultiMap<PsiElement, String> conflicts, Project project2) {
        RefactoringEventData conflictUsages = new RefactoringEventData();
        conflictUsages.putUserData(RefactoringEventData.CONFLICTS_KEY, (Object)conflicts.values());
        ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected(REFACTORING_EXTRACT_SUPER_ID, conflictUsages);
    }

    public static RefactoringEventData createBeforeData(PsiClass subclassClass, MemberInfo[] members) {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)subclassClass);
        data.addMembers((Object[])members, info -> (PsiMember)info.getMember());
        return data;
    }

    public static RefactoringEventData createAfterData(PsiClass subClass) {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)subClass);
        return data;
    }
}

