/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;

public class ReplaceStaticVariableAccess
extends FixableUsageInfo {
    private final PsiReferenceExpression expression;
    private final String delegateClass;
    private final boolean myEnumConstant;
    private static final Logger LOGGER = Logger.getInstance((String)("#" + ReplaceStaticVariableAccess.class.getName()));

    public ReplaceStaticVariableAccess(PsiReferenceExpression expression2, String delegateClass, boolean enumConstant) {
        super((PsiElement)expression2);
        this.expression = expression2;
        this.delegateClass = delegateClass;
        this.myEnumConstant = enumConstant;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiSwitchLabelStatement switchStatement;
        if (this.myEnumConstant && (switchStatement = (PsiSwitchLabelStatement)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiSwitchLabelStatement.class)) != null) {
            MutationUtils.replaceExpression(this.expression.getReferenceName(), (PsiExpression)this.expression);
            return;
        }
        boolean replaceWithGetEnumValue = this.myEnumConstant && !this.alreadyMigratedToEnum();
        String link = replaceWithGetEnumValue ? "." + GenerateMembersUtil.suggestGetterName("value", this.expression.getType(), this.expression.getProject()) + "()" : "";
        MutationUtils.replaceExpression(this.delegateClass + '.' + this.expression.getReferenceName() + link, (PsiExpression)this.expression);
    }

    private boolean alreadyMigratedToEnum() {
        PsiCallExpression callExpression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiCallExpression.class);
        if (callExpression != null) {
            PsiMethod resolvedMethod = callExpression.resolveMethod();
            if (resolvedMethod != null) {
                PsiParameter[] parameters2 = resolvedMethod.getParameterList().getParameters();
                PsiExpression[] args = callExpression.getArgumentList().getExpressions();
                int idx = -1;
                for (int i2 = 0; i2 < args.length; ++i2) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)args[i2], (PsiElement)this.expression, (boolean)false)) continue;
                    idx = i2;
                    break;
                }
                if (idx != -1 && parameters2[idx].getType().equalsToText(this.delegateClass)) {
                    return true;
                }
            }
        } else {
            PsiReturnStatement returnStatement = (PsiReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiReturnStatement.class);
            if (returnStatement != null) {
                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiMethod.class);
                LOGGER.assertTrue(psiMethod != null);
                PsiType returnType = psiMethod.getReturnType();
                if (returnType != null && returnType.getCanonicalText().equals(this.delegateClass)) {
                    return true;
                }
            } else {
                PsiVariable psiVariable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiVariable.class);
                if (psiVariable != null) {
                    if (psiVariable.getType().equalsToText(this.delegateClass)) {
                        return true;
                    }
                } else {
                    PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiAssignmentExpression.class);
                    if (assignmentExpression != null && assignmentExpression.getRExpression() == this.expression) {
                        PsiElement resolve2;
                        PsiExpression lExpression = assignmentExpression.getLExpression();
                        if (lExpression instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable && ((PsiVariable)resolve2).getType().equalsToText(this.delegateClass)) {
                            return true;
                        }
                    } else {
                        Object[] operands2;
                        int index;
                        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiBinaryExpression.class);
                        if (binaryExpression != null && binaryExpression.getOperationTokenType() == JavaTokenType.EQEQ && (index = ArrayUtil.find((Object[])(operands2 = binaryExpression.getOperands()), (Object)this.expression)) >= 0) {
                            PsiType type2 = operands2[index].getType();
                            return type2 != null && type2.equalsToText(this.delegateClass);
                        }
                    }
                }
            }
        }
        return false;
    }
}

