/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InlineStaticImportHandler
extends JavaInlineActionHandler {
    private static final String REFACTORING_NAME = "Expand static import";
    public static final String REFACTORING_ID = "refactoring.inline.import";

    public boolean canInlineElement(PsiElement element) {
        if (element.getContainingFile() == null) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) != null;
    }

    public void inlineElement(Project project2, Editor editor, PsiElement element) {
        final PsiImportStaticStatement staticStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class);
        final List referenceElements = ImportsUtil.collectReferencesThrough((PsiFile)element.getContainingFile(), null, (PsiImportStaticStatement)staticStatement);
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(element);
        ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(REFACTORING_ID, data);
        new WriteCommandAction(project2, REFACTORING_NAME, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                ImportsUtil.replaceAllAndDeleteImport((List)referenceElements, null, (PsiImportStaticStatement)staticStatement);
            }
        }.execute();
        ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(REFACTORING_ID, null);
    }
}

