/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineToAnonymousClassHandler;
import com.intellij.refactoring.inline.InlineToAnonymousConstructorProcessor;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineToAnonymousClassProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineToAnonymousClassProcessor");
    private PsiClass myClass;
    private final PsiCall myCallToInline;
    private final boolean myInlineThisOnly;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;

    protected InlineToAnonymousClassProcessor(Project project2, PsiClass psiClass, @Nullable PsiCall callToInline, boolean inlineThisOnly, boolean searchInComments, boolean searchInNonJavaFiles) {
        super(project2);
        this.myClass = psiClass;
        this.myCallToInline = callToInline;
        this.myInlineThisOnly = inlineThisOnly;
        if (this.myInlineThisOnly) assert (this.myCallToInline != null);
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new InlineViewDescriptor((PsiElement)this.myClass);
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.myInlineThisOnly) {
            return new UsageInfo[]{new UsageInfo((PsiElement)this.myCallToInline)};
        }
        HashSet<UsageInfo> usages = new HashSet<UsageInfo>();
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)this.myProject);
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)searchScope)) {
            usages.add(new UsageInfo(reference.getElement()));
        }
        String qName = this.myClass.getQualifiedName();
        if (qName != null) {
            ArrayList<UsageInfo> nonCodeUsages = new ArrayList<UsageInfo>();
            if (this.mySearchInComments) {
                TextOccurrencesUtil.addUsagesInStringsAndComments((PsiElement)this.myClass, qName, nonCodeUsages, new NonCodeUsageInfoFactory((PsiElement)this.myClass, qName));
            }
            if (this.mySearchInNonJavaFiles) {
                TextOccurrencesUtil.addTextOccurences((PsiElement)this.myClass, qName, searchScope, nonCodeUsages, new NonCodeUsageInfoFactory((PsiElement)this.myClass, qName));
            }
            usages.addAll(nonCodeUsages);
        }
        return usages.toArray(new UsageInfo[usages.size()]);
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (!this.myInlineThisOnly && !this.myClass.isWritable()) {
            return Collections.emptyList();
        }
        return super.getElementsToWrite(descriptor);
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        assert (elements.length == 1);
        this.myClass = (PsiClass)elements[0];
    }

    @Override
    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        for (UsageInfo usage : usages) {
            if (!InlineToAnonymousClassProcessor.isForcePreview(usage)) continue;
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"occurrences.found.in.comments.strings.and.non.java.files"));
            return true;
        }
        return false;
    }

    private static boolean isForcePreview(UsageInfo usage) {
        PsiFile file2;
        if (usage.isNonCodeUsage) {
            return true;
        }
        PsiElement element = usage.getElement();
        return element != null && !((file2 = element.getContainingFile()) instanceof PsiJavaFile);
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        MultiMap<PsiElement, String> conflicts = this.getConflicts((UsageInfo[])refUsages.get());
        if (!conflicts.isEmpty()) {
            return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
        }
        return super.preprocessUsages(refUsages);
    }

    public MultiMap<PsiElement, String> getConflicts(UsageInfo[] usages) {
        final MultiMap result2 = new MultiMap();
        ReferencedElementsCollector collector = new ReferencedElementsCollector(){

            @Override
            protected void checkAddMember(@NotNull PsiMember member) {
                if (PsiTreeUtil.isAncestor((PsiElement)InlineToAnonymousClassProcessor.this.myClass, (PsiElement)member, (boolean)false)) {
                    return;
                }
                PsiModifierList modifierList = member.getModifierList();
                if (member.getContainingClass() == InlineToAnonymousClassProcessor.this.myClass.getSuperClass() && modifierList != null && modifierList.hasModifierProperty("protected")) {
                    return;
                }
                super.checkAddMember(member);
            }
        };
        InlineMethodProcessor.addInaccessibleMemberConflicts((PsiElement)this.myClass, usages, collector, (MultiMap<PsiElement, String>)result2);
        this.myClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitParameter(PsiParameter parameter) {
                super.visitParameter(parameter);
                if (!InlineToAnonymousClassProcessor.this.myClass.isEquivalentTo((PsiElement)PsiUtil.resolveClassInType((PsiType)parameter.getType()))) {
                    return;
                }
                for (PsiReference psiReference : ReferencesSearch.search((PsiElement)parameter)) {
                    PsiElement resolvedMember;
                    PsiReferenceExpression referenceExpression;
                    PsiElement refElement = psiReference.getElement();
                    if (!(refElement instanceof PsiExpression) || (referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)refElement, PsiReferenceExpression.class)) == null || referenceExpression.getQualifierExpression() != refElement || (resolvedMember = referenceExpression.resolve()) == null || !PsiTreeUtil.isAncestor((PsiElement)InlineToAnonymousClassProcessor.this.myClass, (PsiElement)resolvedMember, (boolean)false) || resolvedMember instanceof PsiMethod && InlineToAnonymousClassProcessor.this.myClass.findMethodsBySignature((PsiMethod)resolvedMember, true).length > 1) continue;
                    result2.putValue((Object)refElement, (Object)"Class cannot be inlined because a call to its member inside body");
                }
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                super.visitNewExpression(expression2);
                if (!InlineToAnonymousClassProcessor.this.myClass.isEquivalentTo((PsiElement)PsiUtil.resolveClassInType((PsiType)expression2.getType()))) {
                    return;
                }
                result2.putValue((Object)expression2, (Object)"Class cannot be inlined because a call to its constructor inside body");
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiMethod method2;
                super.visitMethodCallExpression(expression2);
                PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
                if (qualifierExpression2 != null && !InlineToAnonymousClassProcessor.this.myClass.isEquivalentTo((PsiElement)PsiUtil.resolveClassInType((PsiType)qualifierExpression2.getType()))) {
                    return;
                }
                PsiElement resolved = methodExpression.resolve();
                if (resolved instanceof PsiMethod && "getClass".equals((method2 = (PsiMethod)resolved).getName()) && method2.getParameterList().getParametersCount() == 0) {
                    result2.putValue((Object)methodExpression, (Object)"Result of getClass() invocation would be changed");
                }
            }
        });
        return result2;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        PsiClassType superType = InlineToAnonymousClassProcessor.getSuperType(this.myClass);
        LOG.assertTrue(superType != null);
        ArrayList<PsiImportStatement> elementsToDelete = new ArrayList<PsiImportStatement>();
        ArrayList<PsiNewExpression> newExpressions = new ArrayList<PsiNewExpression>();
        for (UsageInfo info : usages) {
            PsiElement element = info.getElement();
            if (element instanceof PsiNewExpression) {
                newExpressions.add((PsiNewExpression)element);
                continue;
            }
            if (element.getParent() instanceof PsiNewExpression) {
                newExpressions.add((PsiNewExpression)element.getParent());
                continue;
            }
            PsiImportStatement statement2 = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class);
            if (statement2 != null && !this.myInlineThisOnly) {
                elementsToDelete.add(statement2);
                continue;
            }
            PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeElement.class);
            if (typeElement == null) continue;
            this.replaceWithSuperType(typeElement, superType);
        }
        Collections.sort(newExpressions, PsiUtil.BY_POSITION);
        for (PsiNewExpression psiNewExpression : newExpressions) {
            this.replaceNewOrType(psiNewExpression, superType);
        }
        for (PsiElement psiElement : elementsToDelete) {
            try {
                if (!psiElement.isValid()) continue;
                psiElement.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!this.myInlineThisOnly && this.myClass.getOriginalElement().isWritable()) {
            try {
                this.myClass.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void replaceNewOrType(PsiNewExpression psiNewExpression, PsiClassType superType) {
        try {
            if (psiNewExpression.getArrayDimensions().length == 0 && psiNewExpression.getArrayInitializer() == null) {
                new InlineToAnonymousConstructorProcessor(this.myClass, psiNewExpression, (PsiType)superType).run();
            } else {
                PsiClass target = superType.resolve();
                assert (target != null) : superType;
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
                PsiJavaCodeReferenceElement element = factory.createClassReferenceElement(target);
                PsiJavaCodeReferenceElement reference = psiNewExpression.getClassReference();
                assert (reference != null) : psiNewExpression;
                reference.replace((PsiElement)element);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void replaceWithSuperType(PsiTypeElement typeElement, PsiClassType superType) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        PsiClassType psiType = (PsiClassType)typeElement.getType();
        PsiClassType.ClassResolveResult classResolveResult = psiType.resolveGenerics();
        PsiType substType = classResolveResult.getSubstitutor().substitute((PsiType)superType);
        assert (this.myClass.isEquivalentTo((PsiElement)classResolveResult.getElement()));
        try {
            PsiElement replaced = typeElement.replace((PsiElement)factory.createTypeElement(substType));
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(replaced);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public static PsiClassType getSuperType(PsiClass aClass) {
        PsiClassType[] classTypes;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null) {
            return null;
        }
        PsiClassType[] interfaceTypes = aClass.getImplementsListTypes();
        PsiClassType superType = interfaceTypes.length > 0 && !InlineToAnonymousClassHandler.isRedundantImplements(superClass, interfaceTypes[0]) ? interfaceTypes[0] : ((classTypes = aClass.getExtendsListTypes()).length > 0 ? classTypes[0] : factory.createType(superClass));
        return superType;
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"inline.to.anonymous.command.name", (Object[])new Object[]{this.myClass.getQualifiedName()});
    }
}

