/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassRefactoringProcessor;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineSuperClassRefactoringDialog
extends InlineOptionsDialog {
    private final PsiClass mySuperClass;
    private final PsiClass myCurrentInheritor;
    private final DocCommentPanel myDocPanel;

    protected InlineSuperClassRefactoringDialog(@NotNull Project project2, PsiClass superClass, PsiClass currentInheritor) {
        super(project2, false, (PsiElement)superClass);
        this.mySuperClass = superClass;
        this.myCurrentInheritor = currentInheritor;
        this.myInvokedOnReference = currentInheritor != null;
        this.myDocPanel = new DocCommentPanel("JavaDoc for inlined members");
        this.myDocPanel.setPolicy(JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC);
        this.init();
        this.setTitle("Inline Super Class");
    }

    @Override
    protected void doAction() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_SUPER_CLASS_THIS = this.isInlineThisOnly();
        }
        this.invokeRefactoring(new InlineSuperClassRefactoringProcessor(this.getProject(), this.isInlineThisOnly() ? this.myCurrentInheritor : null, this.mySuperClass, this.myDocPanel.getPolicy()));
    }

    @Override
    protected JComponent createNorthPanel() {
        return null;
    }

    @Nullable
    protected String getHelpId() {
        return "Inline_Super_Class";
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0);
        panel2.add((Component)this.myDocPanel, gc);
        panel2.add((Component)super.createCenterPanel(), gc);
        gc.weighty = 1.0;
        gc.fill = 1;
        panel2.add(Box.createVerticalGlue(), gc);
        return panel2;
    }

    @Override
    protected String getNameLabelText() {
        return "Class " + this.mySuperClass.getQualifiedName();
    }

    @Override
    protected String getBorderTitle() {
        return "Inline";
    }

    @Override
    protected String getInlineAllText() {
        return RefactoringBundle.message((String)"all.references.and.remove.super.class");
    }

    @Override
    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.super.class");
    }

    @Override
    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_SUPER_CLASS_THIS;
    }
}

