/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduceField.AbstractInplaceIntroduceFieldPopup;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceConstantDialog;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceIntroduceConstantPopup
extends AbstractInplaceIntroduceFieldPopup {
    private final String myInitializerText;
    private JCheckBox myReplaceAllCb;
    private JCheckBox myMoveToAnotherClassCb;
    private String myVisibility;

    public InplaceIntroduceConstantPopup(Project project2, Editor editor, PsiClass parentClass, PsiExpression expr, PsiLocalVariable localVariable, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, PsiElement anchorElement, PsiElement anchorElementIfAll, OccurrenceManager occurrenceManager) {
        super(project2, editor, expr, (PsiVariable)localVariable, occurrences, typeSelectorManager, IntroduceConstantHandler.REFACTORING_NAME, parentClass, anchorElement, occurrenceManager, anchorElementIfAll);
        this.myInitializerText = InplaceIntroduceConstantPopup.getExprText(expr, localVariable);
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0);
        this.myWholePanel.add((Component)this.getPreviewComponent(), gc);
        gc.gridy = 1;
        this.myWholePanel.add((Component)this.createRightPanel(), gc);
        gc.gridy = 2;
        this.myWholePanel.add((Component)this.createLeftPanel(), gc);
    }

    @Nullable
    private static String getExprText(PsiExpression expr, PsiLocalVariable localVariable) {
        String exprText;
        String string = exprText = expr != null ? expr.getText() : null;
        if (localVariable != null) {
            PsiExpression initializer = localVariable.getInitializer();
            return initializer != null ? initializer.getText() : exprText;
        }
        return exprText;
    }

    private JPanel createRightPanel() {
        JPanel right = new JPanel(new GridBagLayout());
        GridBagConstraints rgc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0);
        this.myReplaceAllCb = new JCheckBox("Replace all occurrences");
        this.myReplaceAllCb.setMnemonic('a');
        this.myReplaceAllCb.setFocusable(false);
        this.myReplaceAllCb.setVisible(((PsiExpression[])this.myOccurrences).length > 1);
        right.add((Component)this.myReplaceAllCb, rgc);
        return right;
    }

    private JPanel createLeftPanel() {
        JPanel left = new JPanel(new GridBagLayout());
        this.myMoveToAnotherClassCb = new JCheckBox("Move to another class", JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_MOVE_TO_ANOTHER_CLASS);
        this.myMoveToAnotherClassCb.setMnemonic('m');
        this.myMoveToAnotherClassCb.setFocusable(false);
        left.add((Component)this.myMoveToAnotherClassCb, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return left;
    }

    @NotNull
    private String getSelectedVisibility() {
        if (this.myParentClass != null && this.myParentClass.isInterface()) {
            return "public";
        }
        String initialVisibility = JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY;
        if (initialVisibility == null) {
            initialVisibility = "public";
        } else {
            String effectiveVisibility = IntroduceConstantDialog.getEffectiveVisibility(initialVisibility, (PsiExpression[])this.myOccurrences, this.myParentClass, this.myProject);
            if (effectiveVisibility != null) {
                return effectiveVisibility;
            }
        }
        return initialVisibility;
    }

    @Override
    protected PsiVariable createFieldToStartTemplateOn(final String[] names, final PsiType psiType) {
        final PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        return (PsiVariable)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiField>(){

            public PsiField compute() {
                PsiElement anchorElementIfAll;
                PsiElement finalAnchorElement;
                PsiField field = elementFactory.createFieldFromText(psiType.getCanonicalText() + " " + InplaceIntroduceConstantPopup.this.chooseName(names, InplaceIntroduceConstantPopup.this.myParentClass.getLanguage()) + " = " + InplaceIntroduceConstantPopup.this.myInitializerText + ";", (PsiElement)InplaceIntroduceConstantPopup.this.myParentClass);
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
                InplaceIntroduceConstantPopup.this.myVisibility = InplaceIntroduceConstantPopup.this.getSelectedVisibility();
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)InplaceIntroduceConstantPopup.this.myVisibility, (boolean)true);
                for (finalAnchorElement = anchorElementIfAll = InplaceIntroduceConstantPopup.this.getAnchorElementIfAll(); finalAnchorElement != null && finalAnchorElement.getParent() != InplaceIntroduceConstantPopup.this.myParentClass; finalAnchorElement = finalAnchorElement.getParent()) {
                }
                PsiMember anchorMember = finalAnchorElement instanceof PsiMember ? (PsiMember)finalAnchorElement : null;
                field = BaseExpressionToFieldHandler.ConvertToFieldRunnable.appendField((PsiExpression)InplaceIntroduceConstantPopup.this.myExpr, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, InplaceIntroduceConstantPopup.this.myParentClass, InplaceIntroduceConstantPopup.this.myParentClass, field, anchorMember);
                InplaceIntroduceConstantPopup.this.myFieldRangeStart = InplaceIntroduceConstantPopup.this.myEditor.getDocument().createRangeMarker(field.getTextRange());
                return field;
            }
        });
    }

    @Override
    protected String[] suggestNames(PsiType defaultType, String propName) {
        return IntroduceConstantDialog.createNameSuggestionGenerator((String)propName, (PsiExpression)(this.myExpr != null && ((PsiExpression)this.myExpr).isValid() ? (PsiExpression)this.myExpr : null), (JavaCodeStyleManager)JavaCodeStyleManager.getInstance((Project)this.myProject), null, (PsiClass)this.myParentClass).getSuggestedNameInfo((PsiType)defaultType).names;
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.STATIC_FINAL_FIELD;
    }

    @Override
    public boolean isReplaceAllOccurrences() {
        return this.myReplaceAllCb.isSelected();
    }

    @Override
    public void setReplaceAllOccurrences(boolean allOccurrences) {
        this.myReplaceAllCb.setSelected(allOccurrences);
    }

    @Override
    protected void saveSettings(@NotNull PsiVariable psiVariable) {
        super.saveSettings(psiVariable);
        JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY = this.myVisibility;
    }

    @Override
    protected boolean performRefactoring() {
        JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_MOVE_TO_ANOTHER_CLASS = this.myMoveToAnotherClassCb.isSelected();
        if (this.myMoveToAnotherClassCb.isSelected()) {
            this.myEditor.putUserData(INTRODUCE_RESTART, (Object)true);
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, () -> {
                this.myEditor.putUserData(ACTIVE_INTRODUCE, (Object)this);
                try {
                    IntroduceConstantHandler constantHandler = new IntroduceConstantHandler();
                    PsiLocalVariable localVariable = (PsiLocalVariable)this.getLocalVariable();
                    if (localVariable != null) {
                        constantHandler.invokeImpl(this.myProject, localVariable, this.myEditor);
                    } else {
                        constantHandler.invokeImpl(this.myProject, (PsiExpression)this.myExpr, this.myEditor);
                    }
                }
                finally {
                    this.myEditor.putUserData(INTRODUCE_RESTART, (Object)false);
                    this.myEditor.putUserData(ACTIVE_INTRODUCE, null);
                    this.releaseResources();
                    if (this.myLocalMarker != null) {
                        this.myLocalMarker.dispose();
                    }
                    if (this.myExprMarker != null) {
                        this.myExprMarker.dispose();
                    }
                }
            });
            return false;
        }
        return super.performRefactoring();
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.extractConstant";
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler2, PsiElement element) {
        return handler2 instanceof IntroduceConstantHandler && super.startsOnTheSameElement(handler2, element);
    }

    @Override
    protected boolean startsOnTheSameElements(Editor editor, RefactoringActionHandler handler2, PsiElement[] elements) {
        PsiReference reference;
        PsiVariable variable;
        if (elements.length == 0 && handler2 instanceof IntroduceConstantHandler && (variable = this.getVariable()) != null && (reference = TargetElementUtil.findReference(editor)) instanceof PsiReferenceExpression && reference.resolve() == null && Comparing.strEqual((String)variable.getName(), (String)((PsiReferenceExpression)reference).getReferenceName())) {
            return true;
        }
        return elements.length == 1 && this.startsOnTheSameElement(handler2, elements[0]);
    }

    @Override
    protected void performIntroduce() {
        final BaseExpressionToFieldHandler.Settings settings = new BaseExpressionToFieldHandler.Settings(this.getInputName(), (PsiExpression)this.getExpr(), (PsiExpression[])this.getOccurrences(), this.isReplaceAllOccurrences(), true, true, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, this.myVisibility, (PsiLocalVariable)this.getLocalVariable(), this.getType(), true, this.myParentClass, false, false);
        new WriteCommandAction(this.myProject, this.getCommandName(), this.getCommandName(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (InplaceIntroduceConstantPopup.this.getLocalVariable() != null) {
                    LocalToFieldHandler.IntroduceFieldRunnable fieldRunnable = new LocalToFieldHandler.IntroduceFieldRunnable(false, (PsiLocalVariable)InplaceIntroduceConstantPopup.this.getLocalVariable(), InplaceIntroduceConstantPopup.this.myParentClass, settings, true, (PsiExpression[])InplaceIntroduceConstantPopup.this.myOccurrences);
                    fieldRunnable.run();
                } else {
                    BaseExpressionToFieldHandler.ConvertToFieldRunnable convertToFieldRunnable = new BaseExpressionToFieldHandler.ConvertToFieldRunnable((PsiExpression)InplaceIntroduceConstantPopup.this.myExpr, settings, settings.getForcedType(), (PsiExpression[])InplaceIntroduceConstantPopup.this.myOccurrences, InplaceIntroduceConstantPopup.this.myOccurrenceManager, InplaceIntroduceConstantPopup.this.getAnchorElementIfAll(), InplaceIntroduceConstantPopup.this.getAnchorElement(), InplaceIntroduceConstantPopup.this.myEditor, InplaceIntroduceConstantPopup.this.myParentClass);
                    convertToFieldRunnable.run();
                }
            }
        }.execute();
    }

    @Override
    protected JComponent getComponent() {
        this.myReplaceAllCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InplaceIntroduceConstantPopup.this.restartInplaceIntroduceTemplate();
            }
        });
        return this.myWholePanel;
    }

    @Override
    protected String getActionName() {
        return "IntroduceConstant";
    }
}

