/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OldReferenceResolver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceParameter.OldReferenceResolver");
    private final PsiCall myContext;
    private final PsiExpression myExpr;
    private final HashMap<PsiExpression, String> myTempVars;
    private final PsiExpression myInstanceRef;
    private final PsiExpression[] myActualArgs;
    private final PsiMethod myMethodToReplaceIn;
    private final Project myProject;
    private final PsiManager myManager;
    private final int myReplaceFieldsWithGetters;
    private final PsiElement myParameterInitializer;

    public OldReferenceResolver(PsiCall context, PsiExpression expr, PsiMethod methodToReplaceIn, int replaceFieldsWithGetters, PsiElement parameterInitializer) throws IncorrectOperationException {
        PsiExpression instanceRef;
        this.myContext = context;
        this.myExpr = expr;
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
        this.myParameterInitializer = parameterInitializer;
        this.myTempVars = new HashMap();
        this.myActualArgs = this.myContext.getArgumentList().getExpressions();
        this.myMethodToReplaceIn = methodToReplaceIn;
        this.myProject = this.myContext.getProject();
        this.myManager = this.myContext.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        if (this.myContext instanceof PsiMethodCallExpression) {
            PsiClass thisResolveClass;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)this.myContext;
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            instanceRef = methodExpression.getQualifierExpression();
            if (instanceRef == null && (thisResolveClass = RefactoringUtil.getThisResolveClass(methodExpression)) != null && !(thisResolveClass instanceof PsiAnonymousClass) && !thisResolveClass.equals(PsiTreeUtil.getParentOfType((PsiElement)methodExpression, PsiClass.class))) {
                instanceRef = factory.createExpressionFromText(thisResolveClass.getName() + ".this", null);
            }
        } else {
            instanceRef = null;
        }
        this.myInstanceRef = instanceRef;
    }

    public void resolve() throws IncorrectOperationException {
        this.resolveOldReferences((PsiElement)this.myExpr, this.myParameterInitializer);
        Set mappingsSet = this.myTempVars.entrySet();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        OldReferenceResolver.replaceOldRefWithNew(mappingsSet, factory);
    }

    private static void replaceOldRefWithNew(Set<Map.Entry<PsiExpression, String>> mappingsSet, PsiElementFactory factory) {
        for (Map.Entry<PsiExpression, String> entry : mappingsSet) {
            PsiExpression oldRef = entry.getKey();
            PsiExpression newRef = factory.createExpressionFromText(entry.getValue(), null);
            oldRef.replace((PsiElement)newRef);
        }
    }

    private void resolveOldReferences(PsiElement expr, PsiElement oldExpr) throws IncorrectOperationException {
        if (expr == null || !expr.isValid() || oldExpr == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        PsiElement newExpr = expr;
        if (oldExpr instanceof PsiReferenceExpression) {
            PsiReferenceExpression oldRef = (PsiReferenceExpression)oldExpr;
            JavaResolveResult adv = oldRef.advancedResolve(false);
            PsiElement scope = OldReferenceResolver.getClassContainingResolve(adv);
            PsiElement clss = PsiTreeUtil.getParentOfType((PsiElement)oldExpr, (Class[])new Class[]{PsiClass.class, PsiFunctionalExpression.class});
            if (clss != null && scope != null) {
                PsiElement subj = adv.getElement();
                if (subj instanceof PsiParameter) {
                    PsiParameterList parameterList = this.myMethodToReplaceIn.getParameterList();
                    if (subj.getParent() != parameterList) {
                        return;
                    }
                    final PsiParameter parameter = (PsiParameter)subj;
                    int index = parameterList.getParameterIndex(parameter);
                    if (index < 0) {
                        return;
                    }
                    if (index < this.myActualArgs.length) {
                        PsiExpression actualArg;
                        PsiExpression initializer = actualArg = this.myActualArgs[index];
                        PsiType parameterType = parameter.getType();
                        if (parameter.isVarArgs() && parameterType instanceof PsiEllipsisType) {
                            String varargsJoin = StringUtil.join((String[])((String[])ContainerUtil.map2Array((Object[])this.myActualArgs, String.class, expression2 -> expression2 != null ? expression2.getText() : "null")), (int)(index + 1), (int)this.myActualArgs.length, (String)",");
                            String newArrayInitializer = "new " + ((PsiEllipsisType)parameterType).toArrayType().getCanonicalText() + " {" + varargsJoin + "}";
                            String tempVar = this.getTempVar((PsiExpression)JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)factory.createExpressionFromText(newArrayInitializer, (PsiElement)this.myContext)));
                            HashMap map2 = new HashMap();
                            if (initializer instanceof PsiReferenceExpression && Comparing.strEqual((String)parameter.getName(), (String)initializer.getText())) {
                                newExpr.replace((PsiElement)factory.createExpressionFromText(tempVar, (PsiElement)this.myContext));
                            } else {
                                initializer = (PsiExpression)initializer.copy();
                                initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Map)map2, tempVar){
                                    final /* synthetic */ Map val$map;
                                    final /* synthetic */ String val$tempVar;
                                    {
                                        this.val$map = map2;
                                        this.val$tempVar = string;
                                    }

                                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                                        super.visitReferenceExpression(expression2);
                                        if (Comparing.strEqual((String)parameter.getName(), (String)expression2.getText())) {
                                            this.val$map.put(expression2, this.val$tempVar);
                                        }
                                    }
                                });
                                OldReferenceResolver.replaceOldRefWithNew(map2.entrySet(), factory);
                                newExpr.replace((PsiElement)factory.createExpressionFromText(this.getTempVar(actualArg, initializer), null));
                            }
                            return;
                        }
                        newExpr = RefactoringUtil.verifySafeCopyExpression((PsiElement)actualArg) == 2 ? newExpr.replace((PsiElement)factory.createExpressionFromText(this.getTempVar(actualArg, initializer), null)) : newExpr.replace((PsiElement)initializer);
                    }
                } else if ((subj instanceof PsiField || subj instanceof PsiMethod) && oldRef.getQualifierExpression() == null && PsiTreeUtil.isAncestor((PsiElement)clss, (PsiElement)scope, (boolean)false)) {
                    boolean isStatic;
                    boolean bl = isStatic = subj instanceof PsiField && ((PsiField)subj).hasModifierProperty("static") || subj instanceof PsiMethod && ((PsiMethod)subj).hasModifierProperty("static");
                    if (this.myInstanceRef != null && !isStatic) {
                        String name = ((PsiNamedElement)subj).getName();
                        PsiReferenceExpression newRef = (PsiReferenceExpression)factory.createExpressionFromText("a." + name, null);
                        newRef = (PsiReferenceExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)newRef);
                        PsiExpression instanceRef = this.getInstanceRef(factory);
                        newRef.getQualifierExpression().replace((PsiElement)instanceRef);
                        newRef = (PsiReferenceExpression)newExpr.replace((PsiElement)newRef);
                        newExpr = newRef.getReferenceNameElement();
                    }
                }
                if (subj instanceof PsiField && PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)clss, (boolean)false) && this.myReplaceFieldsWithGetters != 0 && (this.myReplaceFieldsWithGetters == 2 || this.myReplaceFieldsWithGetters == 1 && !JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper().isAccessible((PsiMember)subj, newExpr, null))) {
                    newExpr = this.replaceFieldWithGetter(newExpr, (PsiField)subj, oldRef.getQualifierExpression() == null && !((PsiField)subj).hasModifierProperty("static"));
                }
            }
        } else {
            if (oldExpr instanceof PsiThisExpression && (((PsiThisExpression)oldExpr).getQualifier() == null || this.myManager.areElementsEquivalent(((PsiThisExpression)oldExpr).getQualifier().resolve(), (PsiElement)this.myMethodToReplaceIn.getContainingClass()))) {
                if (this.myInstanceRef != null) {
                    newExpr.replace((PsiElement)this.getInstanceRef(factory));
                }
                return;
            }
            if (oldExpr instanceof PsiSuperExpression && ((PsiSuperExpression)oldExpr).getQualifier() == null) {
                if (this.myInstanceRef != null) {
                    newExpr.replace((PsiElement)this.getInstanceRef(factory));
                }
                return;
            }
        }
        PsiElement[] oldChildren = oldExpr.getChildren();
        PsiElement[] newChildren = newExpr.getChildren();
        if (oldChildren.length == newChildren.length) {
            for (int i2 = 0; i2 < oldChildren.length; ++i2) {
                this.resolveOldReferences(newChildren[i2], oldChildren[i2]);
            }
        }
    }

    private PsiExpression getInstanceRef(PsiElementFactory factory) throws IncorrectOperationException {
        int copyingSafetyLevel = RefactoringUtil.verifySafeCopyExpression((PsiElement)this.myInstanceRef);
        PsiExpression instanceRef = this.myInstanceRef;
        if (copyingSafetyLevel == 2) {
            instanceRef = factory.createExpressionFromText(this.getTempVar(this.myInstanceRef), null);
        }
        return instanceRef;
    }

    private String getTempVar(PsiExpression expr) throws IncorrectOperationException {
        return this.getTempVar(expr, expr);
    }

    private String getTempVar(PsiExpression expr, PsiExpression initializer) throws IncorrectOperationException {
        String id = (String)this.myTempVars.get((Object)expr);
        if (id != null) {
            return id;
        }
        id = RefactoringUtil.createTempVar(initializer, (PsiElement)this.myContext, true);
        this.myTempVars.put((Object)expr, (Object)id);
        return id;
    }

    private PsiElement replaceFieldWithGetter(PsiElement expr, PsiField psiField, boolean qualify) throws IncorrectOperationException {
        if (RefactoringUtil.isAssignmentLHS(expr)) {
            return expr;
        }
        Object newExpr = expr;
        PsiMethod getterPrototype = GenerateMembersUtil.generateGetterPrototype(psiField);
        PsiMethod getter = psiField.getContainingClass().findMethodBySignature(getterPrototype, true);
        if (getter != null && JavaPsiFacade.getInstance((Project)psiField.getProject()).getResolveHelper().isAccessible((PsiMember)getter, newExpr, null)) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)newExpr.getProject()).getElementFactory();
            String id = getter.getName();
            String qualifier = null;
            if (newExpr instanceof PsiReferenceExpression) {
                PsiExpression instanceRef = this.getInstanceRef(factory);
                if (qualify && instanceRef != null) {
                    qualifier = instanceRef.getText();
                } else {
                    PsiExpression qualifierExpression2 = ((PsiReferenceExpression)newExpr).getQualifierExpression();
                    if (qualifierExpression2 != null) {
                        qualifier = qualifierExpression2.getText();
                    }
                }
            }
            PsiMethodCallExpression getterCall = (PsiMethodCallExpression)factory.createExpressionFromText((qualifier != null ? qualifier + "." : "") + id + "()", null);
            getterCall = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)getterCall);
            newExpr = newExpr.getParent() != null ? newExpr.replace((PsiElement)getterCall) : getterCall;
        }
        return newExpr;
    }

    @Nullable
    private static PsiElement getClassContainingResolve(JavaResolveResult result2) {
        PsiElement elem = result2.getElement();
        if (elem != null) {
            if (elem instanceof PsiLocalVariable || elem instanceof PsiParameter) {
                return PsiTreeUtil.getParentOfType((PsiElement)elem, PsiClass.class);
            }
            return result2.getCurrentFileResolveScope();
        }
        return null;
    }
}

