/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReassignVariableUtil {
    static final Key<SmartPsiElementPointer<PsiDeclarationStatement>> DECLARATION_KEY = Key.create((String)"var.type");
    static final Key<RangeMarker[]> OCCURRENCES_KEY = Key.create((String)"occurrences");

    private ReassignVariableUtil() {
    }

    @VisibleForTesting
    public static boolean reassign(Editor editor) {
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)editor.getUserData(DECLARATION_KEY);
        PsiDeclarationStatement declaration2 = pointer != null ? (PsiDeclarationStatement)pointer.getElement() : null;
        PsiType type2 = ReassignVariableUtil.getVariableType(declaration2);
        if (type2 != null) {
            VariablesProcessor proc = ReassignVariableUtil.findVariablesOfType(declaration2, type2);
            if (proc.size() > 0) {
                ArrayList<Object> vars = new ArrayList<Object>();
                for (int i2 = 0; i2 < proc.size(); ++i2) {
                    PsiVariable variable = proc.getResult(i2);
                    PsiElement psiElement = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
                    if (psiElement == null || !ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(psiElement)).forEach(reference -> {
                        PsiElement element = reference.getElement();
                        if (element != null) {
                            return HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, element) == null;
                        }
                        return true;
                    })) continue;
                    vars.add(variable);
                }
                if (vars.isEmpty()) {
                    return true;
                }
                if (vars.size() == 1) {
                    ReassignVariableUtil.replaceWithAssignment(declaration2, proc.getResult(0), editor);
                    return true;
                }
                DefaultListModel<PsiVariable> model = new DefaultListModel<PsiVariable>();
                for (PsiVariable psiVariable : vars) {
                    model.addElement(psiVariable);
                }
                JBList list = new JBList(model);
                list.setCellRenderer((ListCellRenderer)new ListCellRendererWrapper<PsiVariable>(){

                    public void customize(JList list, PsiVariable value2, int index, boolean selected, boolean hasFocus) {
                        if (value2 != null) {
                            this.setText(value2.getName());
                            this.setIcon(value2.getIcon(0));
                        }
                    }
                });
                VisualPosition visualPosition = editor.getCaretModel().getVisualPosition();
                Point point = editor.visualPositionToXY(new VisualPosition(visualPosition.line + 1, visualPosition.column));
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose variable to reassign").setRequestFocus(true).setItemChoosenCallback(() -> ReassignVariableUtil.replaceWithAssignment(declaration2, (PsiVariable)list.getSelectedValue(), editor)).createPopup().show(new RelativePoint((Component)editor.getContentComponent(), point));
            }
            return true;
        }
        return false;
    }

    @Nullable
    static PsiType getVariableType(@Nullable PsiDeclarationStatement declaration2) {
        PsiElement[] declaredElements;
        if (declaration2 != null && (declaredElements = declaration2.getDeclaredElements()).length > 0 && declaredElements[0] instanceof PsiVariable) {
            return ((PsiVariable)declaredElements[0]).getType();
        }
        return null;
    }

    static VariablesProcessor findVariablesOfType(final PsiDeclarationStatement declaration2, final PsiType type2) {
        PsiDeclarationStatement scope;
        VariablesProcessor proc = new VariablesProcessor(false){

            @Override
            protected boolean check(PsiVariable var, ResolveState state) {
                for (PsiElement element : declaration2.getDeclaredElements()) {
                    if (element != var) continue;
                    return false;
                }
                return TypeConversionUtil.isAssignable((PsiType)var.getType(), (PsiType)type2);
            }
        };
        for (scope = declaration2; !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiLambdaExpression || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
        }
        if (scope == null) {
            return proc;
        }
        PsiScopesUtil.treeWalkUp(proc, (PsiElement)declaration2, (PsiElement)scope);
        return proc;
    }

    static void replaceWithAssignment(final PsiDeclarationStatement declaration2, final PsiVariable variable, Editor editor) {
        final PsiVariable var = (PsiVariable)declaration2.getDeclaredElements()[0];
        final PsiExpression initializer = var.getInitializer();
        new WriteCommandAction(declaration2.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
                String chosenVariableName = variable.getName();
                PsiStatement newDeclaration = elementFactory.createStatementFromText(chosenVariableName + " = " + initializer.getText() + ";", (PsiElement)declaration2);
                Collection references = ReferencesSearch.search((PsiElement)var).findAll();
                newDeclaration = declaration2.replace((PsiElement)newDeclaration);
                for (PsiReference reference : references) {
                    PsiElement element = reference.getElement();
                    if (!(element instanceof PsiExpression)) continue;
                    element.replace((PsiElement)elementFactory.createExpressionFromText(chosenVariableName, (PsiElement)newDeclaration));
                }
                PsiModifierList modifierList = variable.getModifierList();
                if (modifierList != null) {
                    modifierList.setModifierProperty("final", false);
                }
            }
        }.execute();
        ReassignVariableUtil.finishTemplate(editor);
    }

    private static void finishTemplate(Editor editor) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        InplaceRefactoring renamer = (InplaceRefactoring)editor.getUserData(InplaceRefactoring.INPLACE_RENAMER);
        if (templateState != null && renamer != null) {
            templateState.gotoEnd(true);
            editor.putUserData(InplaceRefactoring.INPLACE_RENAMER, null);
        }
    }
}

