/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceparameterobject.IntroduceParameterObjectDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class IntroduceParameterObjectHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final String REFACTORING_NAME = RefactorJBundle.message("introduce.parameter.object", new Object[0]);

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        PsiMethod selectedMethod = IntroduceParameterObjectHandler.getSelectedMethod(editor, file2, dataContext);
        if (selectedMethod != null) {
            PsiMethod[] deepestSuperMethods = selectedMethod.findDeepestSuperMethods();
            return deepestSuperMethods.length > 0 || IntroduceParameterObjectHandler.getErrorMessage(selectedMethod) == null;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiMethod selectedMethod = IntroduceParameterObjectHandler.getSelectedMethod(editor, file2, dataContext);
        if (selectedMethod == null) {
            String message2 = RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("the.caret.should.be.positioned.at.the.name.of.the.method.to.be.refactored", new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactorj.introduceParameterObject");
            return;
        }
        IntroduceParameterObjectHandler.invoke(project2, selectedMethod, editor);
    }

    private static PsiMethod getSelectedMethod(Editor editor, PsiFile file2, DataContext dataContext) {
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        PsiMethod selectedMethod = null;
        if (element instanceof PsiMethod) {
            selectedMethod = (PsiMethod)element;
        } else if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod) {
            selectedMethod = (PsiMethod)((PsiParameter)element).getDeclarationScope();
        } else {
            CaretModel caretModel = editor.getCaretModel();
            int position = caretModel.getOffset();
            PsiElement elementAt = file2.findElementAt(position);
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiMethodCallExpression.class);
            if (methodCallExpression != null) {
                selectedMethod = methodCallExpression.resolveMethod();
            } else {
                PsiParameterList parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiParameterList.class);
                if (parameterList != null && parameterList.getParent() instanceof PsiMethod) {
                    selectedMethod = (PsiMethod)parameterList.getParent();
                }
            }
        }
        return selectedMethod;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (elements.length != 1) {
            return;
        }
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)elements[0], PsiMethod.class, (boolean)false);
        if (method2 == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        IntroduceParameterObjectHandler.invoke(project2, method2, editor);
    }

    private static void invoke(Project project2, PsiMethod selectedMethod, Editor editor) {
        PsiMethod newMethod = SuperMethodWarningUtil.checkSuperMethod(selectedMethod, RefactoringBundle.message((String)"to.refactor"));
        if (newMethod == null) {
            return;
        }
        String message2 = IntroduceParameterObjectHandler.getErrorMessage(newMethod);
        if (message2 != null) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactorj.introduceParameterObject");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)newMethod)) {
            return;
        }
        new IntroduceParameterObjectDialog(newMethod).show();
    }

    private static String getErrorMessage(PsiMethod newMethod) {
        PsiParameter[] parameters2 = newMethod.getParameterList().getParameters();
        if (parameters2.length == 0) {
            return RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("method.selected.has.no.parameters", new Object[0]);
        }
        if (newMethod instanceof PsiCompiledElement) {
            return RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("the.selected.method.cannot.be.wrapped.because.it.is.defined.in.a.non.project.class", new Object[0]);
        }
        return null;
    }
}

