/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectClassDescriptor;
import com.intellij.refactoring.introduceparameterobject.ParameterObjectBuilder;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaIntroduceParameterObjectClassDescriptor
extends IntroduceParameterObjectClassDescriptor<PsiMethod, ParameterInfoImpl> {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaIntroduceParameterObjectClassDescriptor.class.getName()));
    private final Set<PsiTypeParameter> myTypeParameters = new LinkedHashSet<PsiTypeParameter>();
    private final Map<ParameterInfoImpl, ParameterBean> myExistingClassProperties = new HashMap();
    private final MoveDestination myMoveDestination;

    public JavaIntroduceParameterObjectClassDescriptor(String className, String packageName, MoveDestination moveDestination, boolean useExistingClass, boolean createInnerClass, String newVisibility, ParameterInfoImpl[] paramsToMerge, PsiMethod method2, boolean generateAccessors) {
        super(className, JavaIntroduceParameterObjectClassDescriptor.calcPackageName(packageName, createInnerClass, method2), useExistingClass, createInnerClass, newVisibility, generateAccessors, (ParameterInfo[])paramsToMerge);
        this.myMoveDestination = moveDestination;
        PsiTypeVisitor<Object> typeParametersVisitor = new PsiTypeVisitor<Object>(){

            public Object visitClassType(PsiClassType classType) {
                PsiClass referent = classType.resolve();
                if (referent instanceof PsiTypeParameter) {
                    JavaIntroduceParameterObjectClassDescriptor.this.myTypeParameters.add((PsiTypeParameter)referent);
                }
                for (PsiType type2 : classType.getParameters()) {
                    type2.accept((PsiTypeVisitor)this);
                }
                return super.visitClassType(classType);
            }
        };
        for (ParameterInfoImpl parameterInfo : paramsToMerge) {
            parameterInfo.getTypeWrapper().getType((PsiElement)method2).accept((PsiTypeVisitor)typeParametersVisitor);
        }
    }

    private static String calcPackageName(String packageName, boolean createInnerClass, PsiMethod method2) {
        if (createInnerClass) {
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass != null) {
                String qualifiedName = containingClass.getQualifiedName();
                return qualifiedName != null ? qualifiedName : "";
            }
            return packageName;
        }
        return packageName;
    }

    public Set<PsiTypeParameter> getTypeParameters() {
        return this.myTypeParameters;
    }

    public MoveDestination getMoveDestination() {
        return this.myMoveDestination;
    }

    public String createFakeClassTypeText() {
        String text = StringUtil.getQualifiedName((String)this.getPackageName(), (String)this.getClassName());
        if (!this.myTypeParameters.isEmpty()) {
            text = text + "<" + StringUtil.join(this.myTypeParameters, PsiNamedElement::getName, (String)", ") + ">";
        }
        return text;
    }

    public PsiClass getExistingClass() {
        return (PsiClass)super.getExistingClass();
    }

    public String getGetter(ParameterInfoImpl param) {
        ParameterBean bean = this.getBean(param);
        return bean != null ? bean.getGetter() : null;
    }

    public String getSetter(ParameterInfoImpl param) {
        ParameterBean bean = this.getBean(param);
        return bean != null ? bean.getSetter() : null;
    }

    @Override
    public String getSetterName(ParameterInfoImpl parameterInfo, @NotNull PsiElement context) {
        String setter;
        ParameterBean bean = this.getBean(parameterInfo);
        String string = setter = bean != null ? bean.getSetter() : null;
        if (setter == null) {
            setter = bean != null && bean.getField() != null ? GenerateMembersUtil.suggestSetterName(bean.getField()) : GenerateMembersUtil.suggestSetterName(parameterInfo.getName(), parameterInfo.getTypeWrapper().getType(context), context.getProject());
        }
        return setter;
    }

    @Override
    public String getGetterName(ParameterInfoImpl paramInfo, @NotNull PsiElement context) {
        String getter;
        ParameterBean bean = this.getBean(paramInfo);
        String string = getter = bean != null ? bean.getGetter() : null;
        if (getter == null) {
            getter = bean != null && bean.getField() != null ? GenerateMembersUtil.suggestGetterName(bean.getField()) : GenerateMembersUtil.suggestGetterName(paramInfo.getName(), paramInfo.getTypeWrapper().getType(context), context.getProject());
        }
        return getter;
    }

    @Override
    public PsiMethod findCompatibleConstructorInExistingClass(PsiMethod method2) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)method2.getProject());
        String qualifiedName = StringUtil.getQualifiedName((String)this.getPackageName(), (String)this.getClassName());
        PsiClass existingClass = psiFacade.findClass(qualifiedName, method2.getResolveScope());
        this.setExistingClass((PsiElement)existingClass);
        return this.findCompatibleConstructor(existingClass);
    }

    @Nullable
    public PsiField getField(ParameterInfoImpl parameter) {
        ParameterBean bean = this.getBean(parameter);
        return bean != null ? bean.getField() : null;
    }

    public ParameterBean getBean(ParameterInfoImpl param) {
        return this.myExistingClassProperties.get(param);
    }

    @Nullable
    private PsiMethod findCompatibleConstructor(@NotNull PsiClass aClass) {
        ParameterInfoImpl[] paramsToMerge = (ParameterInfoImpl[])this.getParamsToMerge();
        if (paramsToMerge.length == 1) {
            ParameterInfoImpl parameterInfo = paramsToMerge[0];
            PsiType paramType = parameterInfo.getTypeWrapper().getType((PsiElement)aClass);
            if (TypeConversionUtil.isPrimitiveWrapper((String)aClass.getQualifiedName())) {
                ParameterBean bean = new ParameterBean();
                bean.setField(aClass.findFieldByName("value", false));
                bean.setGetter(paramType.getCanonicalText() + "Value");
                this.myExistingClassProperties.put(parameterInfo, bean);
                PsiMethod[] psiMethodArray = aClass.getConstructors();
                int n = psiMethodArray.length;
                for (int j = 0; j < n; ++j) {
                    PsiMethod constructor = psiMethodArray[j];
                    if (!JavaIntroduceParameterObjectClassDescriptor.isConstructorCompatible(constructor, new ParameterInfoImpl[]{parameterInfo}, (PsiElement)aClass)) continue;
                    return constructor;
                }
            }
        }
        PsiMethod[] constructors = aClass.getConstructors();
        PsiMethod compatibleConstructor = null;
        for (PsiMethod constructor : constructors) {
            if (!JavaIntroduceParameterObjectClassDescriptor.isConstructorCompatible(constructor, paramsToMerge, (PsiElement)aClass)) continue;
            compatibleConstructor = constructor;
            break;
        }
        PsiField[] fields = aClass.getFields();
        if (compatibleConstructor == null && !JavaIntroduceParameterObjectClassDescriptor.areTypesCompatible((ParameterInfoImpl[])this.getParamsToMerge(), (PsiVariable[])fields, (PsiElement)aClass)) {
            return null;
        }
        PsiField[] constructorParams = compatibleConstructor != null ? compatibleConstructor.getParameterList().getParameters() : fields;
        for (int i2 = 0; i2 < ((ParameterInfoImpl[])this.getParamsToMerge()).length; ++i2) {
            PsiMethod setterForField;
            PsiField field;
            int oldIndex = ((ParameterInfoImpl[])this.getParamsToMerge())[i2].getOldIndex();
            ParameterInfoImpl methodParam = (ParameterInfoImpl)this.getParameterInfo(oldIndex);
            ParameterBean bean = new ParameterBean();
            this.myExistingClassProperties.put(methodParam, bean);
            PsiField var = constructorParams[i2];
            PsiField psiField = field = var instanceof PsiParameter ? JavaIntroduceParameterObjectClassDescriptor.findFieldAssigned((PsiParameter)var, compatibleConstructor) : var;
            if (field == null) {
                return null;
            }
            bean.setField(field);
            PsiMethod getterForField = PropertyUtil.findGetterForField((PsiField)field);
            if (getterForField != null) {
                bean.setGetter(getterForField.getName());
            }
            if ((setterForField = PropertyUtil.findSetterForField((PsiField)field)) == null) continue;
            bean.setSetter(setterForField.getName());
        }
        return compatibleConstructor;
    }

    private static boolean isConstructorCompatible(PsiMethod constructor, ParameterInfoImpl[] paramsToMerge, PsiElement context) {
        PsiParameterList parameterList = constructor.getParameterList();
        PsiParameter[] constructorParams = parameterList.getParameters();
        return JavaIntroduceParameterObjectClassDescriptor.areTypesCompatible(paramsToMerge, (PsiVariable[])constructorParams, context);
    }

    private static boolean areTypesCompatible(ParameterInfoImpl[] expected, PsiVariable[] actual, PsiElement context) {
        if (actual.length != expected.length) {
            return false;
        }
        for (int i2 = 0; i2 < actual.length; ++i2) {
            if (TypeConversionUtil.isAssignable((PsiType)actual[i2].getType(), (PsiType)expected[i2].getTypeWrapper().getType(context))) continue;
            return false;
        }
        return true;
    }

    private static PsiField findFieldAssigned(PsiParameter param, PsiMethod constructor) {
        ParamAssignmentFinder visitor = new ParamAssignmentFinder(param);
        constructor.accept((PsiElementVisitor)visitor);
        return visitor.getFieldAssigned();
    }

    public PsiClass createClass(PsiMethod method2, ReadWriteAccessDetector.Access[] accessors) {
        if (this.isUseExistingClass()) {
            return this.getExistingClass();
        }
        ParameterObjectBuilder beanClassBuilder = new ParameterObjectBuilder();
        beanClassBuilder.setVisibility(this.isCreateInnerClass() ? "private" : "public");
        beanClassBuilder.setProject(method2.getProject());
        beanClassBuilder.setTypeArguments(this.getTypeParameters());
        beanClassBuilder.setClassName(this.getClassName());
        beanClassBuilder.setPackageName(this.getPackageName());
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        ParameterInfoImpl[] parameterInfos = (ParameterInfoImpl[])this.getParamsToMerge();
        for (int i2 = 0; i2 < parameterInfos.length; ++i2) {
            PsiParameter parameter = parameters2[parameterInfos[i2].getOldIndex()];
            boolean setterRequired = accessors[i2] == ReadWriteAccessDetector.Access.Write;
            String newName = parameterInfos[i2].getName();
            beanClassBuilder.addField(parameter, newName, parameterInfos[i2].getTypeWrapper().getType((PsiElement)method2), setterRequired);
        }
        String classString = beanClassBuilder.buildBeanClass();
        try {
            PsiDirectory directory;
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)method2.getProject());
            PsiJavaFile newFile = (PsiJavaFile)factory.createFileFromText(this.getClassName() + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)classString);
            if (this.isCreateInnerClass()) {
                PsiClass containingClass = method2.getContainingClass();
                PsiClass[] classes2 = newFile.getClasses();
                assert (classes2.length > 0) : classString;
                PsiClass innerClass = (PsiClass)containingClass.add((PsiElement)classes2[0]);
                PsiUtil.setModifierProperty((PsiModifierListOwner)innerClass, (String)"static", (boolean)true);
                return (PsiClass)JavaCodeStyleManager.getInstance((Project)newFile.getProject()).shortenClassReferences((PsiElement)innerClass);
            }
            PsiFile containingFile = method2.getContainingFile();
            PsiDirectory containingDirectory = containingFile.getContainingDirectory();
            MoveDestination moveDestination = this.getMoveDestination();
            if (moveDestination != null) {
                directory = moveDestination.getTargetDirectory(containingDirectory);
            } else {
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
                directory = PackageUtil.findOrCreateDirectoryForPackage(module2, this.getPackageName(), containingDirectory, true, true);
            }
            if (directory != null) {
                PsiFile file2 = directory.findFile(newFile.getName());
                if (file2 == null) {
                    CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)method2.getManager().getProject());
                    PsiElement shortenedFile = JavaCodeStyleManager.getInstance((Project)newFile.getProject()).shortenClassReferences((PsiElement)newFile);
                    PsiElement reformattedFile = codeStyleManager.reformat(shortenedFile);
                    file2 = (PsiFile)directory.add(reformattedFile);
                }
                return ((PsiJavaFile)file2).getClasses()[0];
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private static class ParameterBean {
        private PsiField myField;
        private String myGetter;
        private String mySetter;

        private ParameterBean() {
        }

        public PsiField getField() {
            return this.myField;
        }

        public void setField(PsiField field) {
            this.myField = field;
        }

        public String getGetter() {
            return this.myGetter;
        }

        public void setGetter(String getter) {
            this.myGetter = getter;
        }

        public String getSetter() {
            return this.mySetter;
        }

        public void setSetter(String setter) {
            this.mySetter = setter;
        }
    }

    private static class ParamAssignmentFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiParameter param;
        private PsiField fieldAssigned;

        ParamAssignmentFinder(PsiParameter param) {
            this.param = param;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
            super.visitAssignmentExpression(assignment);
            PsiExpression lhs = assignment.getLExpression();
            PsiExpression rhs = assignment.getRExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)rhs).resolve();
            if (referent == null || !referent.equals(this.param)) {
                return;
            }
            PsiElement assigned = ((PsiReference)lhs).resolve();
            if (assigned == null || !(assigned instanceof PsiField)) {
                return;
            }
            this.fieldAssigned = (PsiField)assigned;
        }

        public PsiField getFieldAssigned() {
            return this.fieldAssigned;
        }
    }
}

