/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.MethodCallUsageInfo;
import com.intellij.refactoring.changeSignature.OverriderMethodUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectClassDescriptor;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectDelegate;
import com.intellij.refactoring.introduceParameterObject.IntroduceParameterObjectProcessor;
import com.intellij.refactoring.introduceparameterobject.IntroduceParameterObjectHandler;
import com.intellij.refactoring.introduceparameterobject.JavaIntroduceParameterObjectClassDescriptor;
import com.intellij.refactoring.introduceparameterobject.usageInfo.AppendAccessorsUsageInfo;
import com.intellij.refactoring.introduceparameterobject.usageInfo.BeanClassVisibilityUsageInfo;
import com.intellij.refactoring.introduceparameterobject.usageInfo.ConstructorJavadocUsageInfo;
import com.intellij.refactoring.introduceparameterobject.usageInfo.ReplaceParameterAssignmentWithCall;
import com.intellij.refactoring.introduceparameterobject.usageInfo.ReplaceParameterIncrementDecrement;
import com.intellij.refactoring.introduceparameterobject.usageInfo.ReplaceParameterReferenceWithCall;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaIntroduceParameterObjectDelegate
extends IntroduceParameterObjectDelegate<PsiMethod, ParameterInfoImpl, JavaIntroduceParameterObjectClassDescriptor> {
    @Override
    public List<ParameterInfoImpl> getAllMethodParameters(PsiMethod sourceMethod) {
        return new JavaMethodDescriptor(sourceMethod).getParameters();
    }

    @Override
    public boolean isEnabledOn(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false) != null;
    }

    @Override
    public RefactoringActionHandler getHandler(PsiElement element) {
        return new IntroduceParameterObjectHandler();
    }

    @Override
    public ParameterInfoImpl createMergedParameterInfo(final JavaIntroduceParameterObjectClassDescriptor descriptor, PsiMethod method2, final List<ParameterInfoImpl> oldMethodParameters) {
        PsiCodeBlock body2 = method2.getBody();
        String baseParameterName = StringUtil.decapitalize((String)descriptor.getClassName());
        Project project2 = method2.getProject();
        if (!PsiNameHelper.getInstance((Project)project2).isIdentifier(baseParameterName, LanguageLevel.HIGHEST)) {
            baseParameterName = StringUtil.fixVariableNameDerivedFromPropertyName((String)baseParameterName);
        }
        String paramName = body2 != null ? JavaCodeStyleManager.getInstance((Project)project2).suggestUniqueVariableName(baseParameterName, (PsiElement)body2.getLBrace(), true) : JavaCodeStyleManager.getInstance((Project)project2).propertyNameToVariableName(baseParameterName, VariableKind.PARAMETER);
        String classTypeText = descriptor.createFakeClassTypeText();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        return new ParameterInfoImpl(-1, paramName, facade.getElementFactory().createTypeFromText(classTypeText, (PsiElement)method2), null){

            @Override
            @Nullable
            public PsiElement getActualValue(PsiElement exp, Object substitutor) {
                IntroduceParameterObjectDelegate delegate = IntroduceParameterObjectDelegate.findDelegate(exp);
                return delegate != null ? delegate.createNewParameterInitializerAtCallSite(exp, descriptor, oldMethodParameters, substitutor) : null;
            }
        };
    }

    @Override
    public PsiElement createNewParameterInitializerAtCallSite(PsiElement callExpression, IntroduceParameterObjectClassDescriptor descriptor, List<? extends ParameterInfo> oldMethodParameters, Object substitutor) {
        if (callExpression instanceof PsiCallExpression) {
            String qualifiedName;
            PsiCallExpression expr = (PsiCallExpression)callExpression;
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expr.getProject());
            PsiClass existingClass = facade.findClass(qualifiedName = StringUtil.getQualifiedName((String)descriptor.getPackageName(), (String)descriptor.getClassName()), expr.getResolveScope());
            if (existingClass == null) {
                return null;
            }
            PsiExpressionList argumentList = expr.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            StringBuilder newExpression = new StringBuilder();
            newExpression.append("new ").append(existingClass.getQualifiedName());
            if (descriptor instanceof JavaIntroduceParameterObjectClassDescriptor) {
                ArrayList<String> types = new ArrayList<String>();
                for (PsiTypeParameter parameter : ((JavaIntroduceParameterObjectClassDescriptor)descriptor).getTypeParameters()) {
                    PsiType type2 = ((PsiSubstitutor)substitutor).substitute(parameter);
                    if (type2 == null) {
                        types.clear();
                        break;
                    }
                    types.add(type2.getCanonicalText());
                }
                if (!types.isEmpty()) {
                    newExpression.append("<").append(StringUtil.join(types, (String)", ")).append(">");
                }
            }
            newExpression.append('(');
            newExpression.append(JavaIntroduceParameterObjectDelegate.getMergedArgs(descriptor, oldMethodParameters, (PsiElement[])args));
            newExpression.append(')');
            PsiNewExpression newClassExpression = (PsiNewExpression)JavaCodeStyleManager.getInstance((Project)callExpression.getProject()).shortenClassReferences((PsiElement)facade.getElementFactory().createExpressionFromText(newExpression.toString(), (PsiElement)expr));
            if (PsiDiamondTypeUtil.canChangeContextForDiamond(newClassExpression, newClassExpression.getType())) {
                PsiDiamondTypeUtil.replaceExplicitWithDiamond((PsiElement)newClassExpression.getClassOrAnonymousClassReference().getParameterList());
            }
            return newClassExpression;
        }
        return null;
    }

    public static String getMergedArgs(IntroduceParameterObjectClassDescriptor descriptor, List<? extends ParameterInfo> oldMethodParameters, PsiElement[] args) {
        StringBuilder newExpression = new StringBuilder();
        Object[] paramsToMerge = descriptor.getParamsToMerge();
        newExpression.append(StringUtil.join((Object[])paramsToMerge, parameterInfo -> JavaIntroduceParameterObjectDelegate.getArgument(args, parameterInfo.getOldIndex(), oldMethodParameters), (String)", "));
        Object lastParam = paramsToMerge[paramsToMerge.length - 1];
        if (lastParam instanceof JavaParameterInfo && ((JavaParameterInfo)lastParam).isVarargType()) {
            int lastArg = lastParam.getOldIndex();
            for (int i2 = lastArg + 1; i2 < args.length; ++i2) {
                newExpression.append(',');
                newExpression.append(JavaIntroduceParameterObjectDelegate.getArgument(args, i2, oldMethodParameters));
            }
        }
        return newExpression.toString();
    }

    @Nullable
    private static String getArgument(PsiElement[] args, int i2, List<? extends ParameterInfo> oldParameters) {
        if (i2 < args.length) {
            return args[i2].getText();
        }
        return i2 < oldParameters.size() ? oldParameters.get(i2).getName() : null;
    }

    @Override
    public ChangeInfo createChangeSignatureInfo(PsiMethod method2, List<ParameterInfoImpl> newParameterInfos, boolean delegate) {
        PsiType returnType = method2.getReturnType();
        return new JavaChangeInfoImpl(VisibilityUtil.getVisibilityModifier((PsiModifierList)method2.getModifierList()), method2, method2.getName(), returnType != null ? CanonicalTypes.createTypeWrapper(returnType) : null, newParameterInfos.toArray(new ParameterInfoImpl[newParameterInfos.size()]), null, delegate, Collections.emptySet(), Collections.emptySet());
    }

    @Override
    public <M1 extends PsiNamedElement, P1 extends ParameterInfo> ReadWriteAccessDetector.Access collectInternalUsages(Collection<FixableUsageInfo> usages, PsiMethod overridingMethod, IntroduceParameterObjectClassDescriptor<M1, P1> classDescriptor, P1 parameterInfo, String mergedParamName) {
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)overridingMethod);
        PsiParameter[] params = overridingMethod.getParameterList().getParameters();
        PsiParameter parameter = params[parameterInfo.getOldIndex()];
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)parameter);
        assert (detector != null);
        String setter = classDescriptor.getSetterName(parameterInfo, (PsiElement)overridingMethod);
        String getter = classDescriptor.getGetterName(parameterInfo, (PsiElement)overridingMethod);
        ReadWriteAccessDetector.Access[] accessor = new ReadWriteAccessDetector.Access[]{null};
        ReferencesSearch.search((PsiElement)parameter, (SearchScope)localSearchScope).forEach(reference -> {
            PsiElement refElement = reference.getElement();
            if (refElement instanceof PsiReferenceExpression) {
                PsiReferenceExpression paramUsage = (PsiReferenceExpression)refElement;
                ReadWriteAccessDetector.Access access = detector.getExpressionAccess(refElement);
                if (access == ReadWriteAccessDetector.Access.Read) {
                    usages.add(new ReplaceParameterReferenceWithCall(paramUsage, mergedParamName, getter));
                    if (accessor[0] == null) {
                        accessor[0] = ReadWriteAccessDetector.Access.Read;
                    }
                } else {
                    if (access == ReadWriteAccessDetector.Access.ReadWrite) {
                        usages.add(new ReplaceParameterIncrementDecrement((PsiExpression)paramUsage, mergedParamName, setter, getter));
                    } else {
                        usages.add(new ReplaceParameterAssignmentWithCall(paramUsage, mergedParamName, setter, getter));
                    }
                    accessor[0] = ReadWriteAccessDetector.Access.Write;
                }
            }
            return true;
        });
        return accessor[0];
    }

    @Override
    public void collectUsagesToGenerateMissedFieldAccessors(Collection<FixableUsageInfo> usages, PsiMethod method2, JavaIntroduceParameterObjectClassDescriptor descriptor, ReadWriteAccessDetector.Access[] accessors) {
        ParameterInfoImpl[] parameterInfos = (ParameterInfoImpl[])descriptor.getParamsToMerge();
        PsiClass existingClass = descriptor.getExistingClass();
        boolean useExisting = descriptor.isGenerateAccessors() || !descriptor.isUseExistingClass() || existingClass == null;
        PsiParameter[] psiParameters = method2.getParameterList().getParameters();
        for (int i2 = 0; i2 < parameterInfos.length; ++i2) {
            int oldParamIdx = parameterInfos[i2].getOldIndex();
            ReadWriteAccessDetector.Access accessor = accessors[i2];
            if (accessor == null) continue;
            ParameterInfoImpl parameterInfo = parameterInfos[i2];
            PsiParameter parameter = psiParameters[oldParamIdx];
            PsiField field = descriptor.getField(parameterInfo);
            String getter = descriptor.getGetter(parameterInfo);
            if (getter == null) {
                usages.add(new AppendAccessorsUsageInfo(parameter, existingClass, useExisting, parameterInfo, true, field));
            }
            if (accessor != ReadWriteAccessDetector.Access.Write || descriptor.getSetter(parameterInfo) != null) continue;
            usages.add(new AppendAccessorsUsageInfo(parameter, existingClass, useExisting, parameterInfo, false, field));
        }
    }

    @Override
    public void collectAdditionalFixes(Collection<FixableUsageInfo> usages, final PsiMethod method2, final JavaIntroduceParameterObjectClassDescriptor descriptor) {
        String newVisibility;
        if (method2.getDocComment() != null) {
            usages.add(new ConstructorJavadocUsageInfo(method2, descriptor));
        }
        if ((newVisibility = descriptor.getNewVisibility()) != null) {
            usages.add(new BeanClassVisibilityUsageInfo(descriptor.getExistingClass(), usages.toArray(UsageInfo.EMPTY_ARRAY), newVisibility, descriptor));
        }
        if (!descriptor.isUseExistingClass()) {
            usages.add(new FixableUsageInfo((PsiElement)method2){

                @Override
                public void fixUsage() throws IncorrectOperationException {
                    PsiClass psiClass = descriptor.getExistingClass();
                    for (PsiReference reference : ReferencesSearch.search((PsiElement)method2)) {
                        PsiElement place = reference.getElement();
                        VisibilityUtil.escalateVisibility((PsiMember)psiClass, (PsiElement)place);
                        for (PsiMethod constructor : psiClass.getConstructors()) {
                            VisibilityUtil.escalateVisibility((PsiMember)constructor, (PsiElement)place);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void collectConflicts(MultiMap<PsiElement, String> conflicts, UsageInfo[] infos, PsiMethod method2, JavaIntroduceParameterObjectClassDescriptor classDescriptor) {
        MoveDestination moveDestination = classDescriptor.getMoveDestination();
        if (moveDestination != null) {
            VirtualFile virtualFile;
            PsiFile file2;
            PsiFile containingFile;
            PsiDirectory containingDirectory;
            PsiDirectory directory;
            if (!moveDestination.isTargetAccessible(method2.getProject(), method2.getContainingFile().getVirtualFile())) {
                conflicts.putValue((Object)method2, (Object)"Created class won't be accessible");
            }
            if (!classDescriptor.isCreateInnerClass() && !classDescriptor.isUseExistingClass() && (directory = moveDestination.getTargetDirectory(containingDirectory = (containingFile = method2.getContainingFile()).getContainingDirectory())) != null && (file2 = directory.findFile(classDescriptor.getClassName() + ".java")) != null && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file2)) != null) {
                conflicts.putValue((Object)method2, (Object)("File already exits: " + virtualFile.getPresentableUrl()));
            }
        }
        if (moveDestination != null) {
            boolean constructorMiss = false;
            for (UsageInfo info : infos) {
                PsiNamedElement overridingMethod;
                if (!(info instanceof IntroduceParameterObjectProcessor.ChangeSignatureUsageWrapper)) continue;
                UsageInfo usageInfo = ((IntroduceParameterObjectProcessor.ChangeSignatureUsageWrapper)info).getInfo();
                if (usageInfo instanceof OverriderMethodUsageInfo && !moveDestination.isTargetAccessible((overridingMethod = ((OverriderMethodUsageInfo)usageInfo).getOverridingMethod()).getProject(), overridingMethod.getContainingFile().getVirtualFile())) {
                    conflicts.putValue((Object)overridingMethod, (Object)"Created class won't be accessible");
                }
                if (constructorMiss || !classDescriptor.isUseExistingClass() || !(usageInfo instanceof MethodCallUsageInfo) || classDescriptor.getExistingClassCompatibleConstructor() != null) continue;
                conflicts.putValue((Object)classDescriptor.getExistingClass(), (Object)"Existing class misses compatible constructor");
                constructorMiss = true;
            }
        }
        if (classDescriptor.isUseExistingClass()) {
            for (ParameterInfoImpl info : (ParameterInfoImpl[])classDescriptor.getParamsToMerge()) {
                JavaIntroduceParameterObjectClassDescriptor.ParameterBean existingClassBean = classDescriptor.getBean(info);
                if (existingClassBean != null) continue;
                conflicts.putValue((Object)classDescriptor.getExistingClass(), (Object)("No field associated with " + info.getName() + " found"));
            }
        }
    }
}

