/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.invertBoolean.InvertBooleanDelegate;
import com.intellij.refactoring.invertBoolean.InvertBooleanDialog;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class InvertBooleanHandler
implements RefactoringActionHandler {
    public static final String INVERT_BOOLEAN_HELP_ID = "refactoring.invertBoolean";
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"invert.boolean.title");
    private static final Logger LOG = Logger.getInstance((String)("#" + InvertBooleanHandler.class.getName()));

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        InvertBooleanDelegate delegate = InvertBooleanHandler.findDelegate(element, project2, editor);
        if (delegate == null) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.variable.name")), (String)REFACTORING_NAME, (String)INVERT_BOOLEAN_HELP_ID);
            return;
        }
        PsiElement namedElement = delegate.adjustElement(element, project2, editor);
        if (namedElement != null && PsiElementRenameHandler.canRename(project2, editor, namedElement)) {
            new InvertBooleanDialog(namedElement).show();
        }
    }

    public static InvertBooleanDelegate findDelegate(PsiElement element, Project project2, Editor editor) {
        for (InvertBooleanDelegate delegate : (InvertBooleanDelegate[])Extensions.getExtensions(InvertBooleanDelegate.EP_NAME)) {
            if (!delegate.isVisibleOnElement(element)) continue;
            return delegate;
        }
        return null;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        LOG.assertTrue(elements.length == 1);
        InvertBooleanDelegate delegate = InvertBooleanHandler.findDelegate(elements[0], project2, null);
        if (delegate == null) {
            CommonRefactoringUtil.showErrorHint((Project)project2, null, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.variable.name")), (String)REFACTORING_NAME, (String)INVERT_BOOLEAN_HELP_ID);
            return;
        }
        PsiElement element = delegate.adjustElement(elements[0], project2, null);
        if (element != null && PsiElementRenameHandler.canRename(project2, null, element)) {
            new InvertBooleanDialog(element).show();
        }
    }
}

