/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.refactoring.migration.MigrationUsagesViewDescriptor;
import com.intellij.refactoring.migration.MigrationUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class MigrationProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.migration.MigrationProcessor");
    private final MigrationMap myMigrationMap;
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"migration.title");
    private PsiMigration myPsiMigration;
    private final GlobalSearchScope mySearchScope;
    private ArrayList<SmartPsiElementPointer<PsiElement>> myRefsToShorten;

    public MigrationProcessor(Project project2, MigrationMap migrationMap) {
        this(project2, migrationMap, GlobalSearchScope.projectScope((Project)project2));
    }

    public MigrationProcessor(Project project2, MigrationMap migrationMap, GlobalSearchScope scope) {
        super(project2);
        this.myMigrationMap = migrationMap;
        this.mySearchScope = scope;
        this.myPsiMigration = this.startMigration(project2);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new MigrationUsagesViewDescriptor(this.myMigrationMap, false);
    }

    private PsiMigration startMigration(Project project2) {
        PsiMigration migration = PsiMigrationManager.getInstance(project2).startMigration();
        this.findOrCreateEntries(project2, migration);
        return migration;
    }

    private void findOrCreateEntries(Project project2, PsiMigration migration) {
        for (int i2 = 0; i2 < this.myMigrationMap.getEntryCount(); ++i2) {
            MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i2);
            if (entry.getType() == 0) {
                MigrationUtil.findOrCreatePackage(project2, migration, entry.getOldName());
                continue;
            }
            MigrationUtil.findOrCreateClass(project2, migration, entry.getOldName());
        }
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        this.myPsiMigration = this.startMigration(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<MigrationUsageInfo> usagesVector = new ArrayList<MigrationUsageInfo>();
        try {
            if (this.myMigrationMap == null) {
                UsageInfo[] usageInfoArray = UsageInfo.EMPTY_ARRAY;
                return usageInfoArray;
            }
            for (int i2 = 0; i2 < this.myMigrationMap.getEntryCount(); ++i2) {
                MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i2);
                UsageInfo[] usages = entry.getType() == 0 ? MigrationUtil.findPackageUsages(this.myProject, this.myPsiMigration, entry.getOldName(), this.mySearchScope) : MigrationUtil.findClassUsages(this.myProject, this.myPsiMigration, entry.getOldName(), this.mySearchScope);
                for (UsageInfo usage : usages) {
                    usagesVector.add(new MigrationUsageInfo(usage, entry));
                }
            }
        }
        finally {
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                this.finishFindMigration();
            } else {
                application.invokeLater(() -> WriteAction.run(() -> this.finishFindMigration()), ModalityState.NON_MODAL);
            }
        }
        return usagesVector.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private void finishFindMigration() {
        this.myPsiMigration.finish();
        this.myPsiMigration = null;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (((UsageInfo[])refUsages.get()).length == 0) {
            Messages.showInfoMessage((Project)this.myProject, (String)RefactoringBundle.message((String)"migration.no.usages.found.in.the.project"), (String)REFACTORING_NAME);
            return false;
        }
        this.setPreviewUsages(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        PsiMigration psiMigration = PsiMigrationManager.getInstance(this.myProject).startMigration();
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        this.myRefsToShorten = new ArrayList();
        try {
            boolean sameShortNames = false;
            for (int i2 = 0; i2 < this.myMigrationMap.getEntryCount(); ++i2) {
                MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i2);
                String newName = entry.getNewName();
                PsiPackage element = entry.getType() == 0 ? MigrationUtil.findOrCreatePackage(this.myProject, psiMigration, newName) : MigrationUtil.findOrCreateClass(this.myProject, psiMigration, newName);
                MigrationUtil.doMigration((PsiElement)element, newName, usages, this.myRefsToShorten);
                if (sameShortNames || !Comparing.strEqual((String)StringUtil.getShortName((String)entry.getOldName()), (String)StringUtil.getShortName((String)entry.getNewName()))) continue;
                sameShortNames = true;
            }
            if (!sameShortNames) {
                this.myRefsToShorten.clear();
            }
        }
        finally {
            a.finish();
            psiMigration.finish();
        }
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        for (SmartPsiElementPointer<PsiElement> pointer : this.myRefsToShorten) {
            PsiElement element = pointer.getElement();
            if (element == null) continue;
            styleManager.shortenClassReferences(element);
        }
    }

    @Override
    protected String getCommandName() {
        return REFACTORING_NAME;
    }

    static class MigrationUsageInfo
    extends UsageInfo {
        MigrationMapEntry mapEntry;

        MigrationUsageInfo(UsageInfo info, MigrationMapEntry mapEntry) {
            super(info.getElement(), info.getRangeInElement().getStartOffset(), info.getRangeInElement().getEndOffset());
            this.mapEntry = mapEntry;
        }
    }
}

