/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.MoveMultipleElementsViewDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.CommonMoveUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.PackageLocalsUsageCollector;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MoveClassToInnerProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerProcessor");
    public static final Key<List<NonCodeUsageInfo>> ourNonCodeUsageKey = Key.create((String)"MoveClassToInner.NonCodeUsage");
    private PsiClass[] myClassesToMove;
    private final PsiClass myTargetClass;
    private PsiPackage[] mySourcePackage;
    private final PsiPackage myTargetPackage;
    private String[] mySourceVisibility;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final MoveCallback myMoveCallback;
    private boolean myOpenInEditor;

    public MoveClassToInnerProcessor(Project project2, PsiClass[] classesToMove, @NotNull PsiClass targetClass, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback) {
        super(project2);
        this.setClassesToMove(classesToMove);
        this.myTargetClass = targetClass;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
        this.myTargetPackage = JavaDirectoryService.getInstance().getPackage(this.myTargetClass.getContainingFile().getContainingDirectory());
    }

    private void setClassesToMove(PsiClass[] classesToMove) {
        this.myClassesToMove = classesToMove;
        this.mySourcePackage = new PsiPackage[classesToMove.length];
        this.mySourceVisibility = new String[classesToMove.length];
        for (int i2 = 0; i2 < classesToMove.length; ++i2) {
            PsiClass psiClass = classesToMove[i2];
            this.mySourceVisibility[i2] = VisibilityUtil.getVisibilityModifier((PsiModifierList)psiClass.getModifierList());
            this.mySourcePackage[i2] = JavaDirectoryService.getInstance().getPackage(psiClass.getContainingFile().getContainingDirectory());
        }
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new MoveMultipleElementsViewDescriptor((PsiElement[])this.myClassesToMove, this.myTargetClass.getQualifiedName());
    }

    @Override
    @NotNull
    public UsageInfo[] findUsages() {
        ArrayList usages = new ArrayList();
        for (PsiClass classToMove : this.myClassesToMove) {
            String newName = this.myTargetClass.getQualifiedName() + "." + classToMove.getName();
            Collections.addAll(usages, MoveClassesOrPackagesUtil.findUsages((PsiElement)classToMove, this.mySearchInComments, this.mySearchInNonJavaFiles, newName));
        }
        return usages.toArray(new UsageInfo[usages.size()]);
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        return this.showConflicts(this.getConflicts(usages), usages);
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass[] classesToMove = new PsiClass[elements.length];
            for (int i2 = 0; i2 < classesToMove.length; ++i2) {
                classesToMove[i2] = (PsiClass)elements[i2];
            }
            this.setClassesToMove(classesToMove);
        });
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        MoveClassToInnerHandler[] handlers = (MoveClassToInnerHandler[])MoveClassToInnerHandler.EP_NAME.getExtensions();
        ArrayList<UsageInfo> usageList = new ArrayList<UsageInfo>(Arrays.asList(usages));
        ArrayList<PsiElement> importStatements = new ArrayList<PsiElement>();
        for (MoveClassToInnerHandler handler2 : handlers) {
            importStatements.addAll(handler2.filterImports(usageList, this.myProject));
        }
        usages = usageList.toArray(new UsageInfo[usageList.size()]);
        this.saveNonCodeUsages(usages);
        HashMap<PsiElement, PsiElement> oldToNewElementsMapping = new HashMap<PsiElement, PsiElement>();
        try {
            PsiElement item;
            for (PsiClass psiClass : this.myClassesToMove) {
                MoveClassToInnerHandler handler3;
                PsiClass newClass = null;
                MoveClassToInnerHandler[] moveClassToInnerHandlerArray = handlers;
                int n = moveClassToInnerHandlerArray.length;
                for (int j = 0; j < n && (newClass = (handler3 = moveClassToInnerHandlerArray[j]).moveClass(psiClass, this.myTargetClass)) == null; ++j) {
                }
                LOG.assertTrue(newClass != null, (Object)("There is no appropriate MoveClassToInnerHandler for " + this.myTargetClass + "; " + psiClass));
                oldToNewElementsMapping.put((PsiElement)psiClass, (PsiElement)newClass);
            }
            this.myNonCodeUsages = CommonMoveUtil.retargetUsages(usages, oldToNewElementsMapping);
            for (PsiClass psiClass : handlers) {
                psiClass.retargetNonCodeUsages(oldToNewElementsMapping, this.myNonCodeUsages);
            }
            for (PsiClass psiClass : handlers) {
                psiClass.retargetClassRefsInMoved(oldToNewElementsMapping);
            }
            for (PsiClass psiClass : handlers) {
                psiClass.removeRedundantImports(this.myTargetClass.getContainingFile());
            }
            for (PsiClass psiClass : this.myClassesToMove) {
                psiClass.delete();
            }
            for (PsiElement element : importStatements) {
                if (!element.isValid()) continue;
                element.delete();
            }
            if (this.myOpenInEditor && !oldToNewElementsMapping.isEmpty() && (item = (PsiElement)ContainerUtil.getFirstItem(oldToNewElementsMapping.values())) != null) {
                EditorHelper.openInEditor(item);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void saveNonCodeUsages(UsageInfo[] usages) {
        for (PsiClass classToMove : this.myClassesToMove) {
            for (UsageInfo usageInfo : usages) {
                NonCodeUsageInfo nonCodeUsage;
                PsiElement element;
                if (!(usageInfo instanceof NonCodeUsageInfo) || (element = (nonCodeUsage = (NonCodeUsageInfo)usageInfo).getElement()) == null || !PsiTreeUtil.isAncestor((PsiElement)classToMove, (PsiElement)element, (boolean)false)) continue;
                ArrayList<NonCodeUsageInfo> list = (ArrayList<NonCodeUsageInfo>)element.getCopyableUserData(ourNonCodeUsageKey);
                if (list == null) {
                    list = new ArrayList<NonCodeUsageInfo>();
                    element.putCopyableUserData(ourNonCodeUsageKey, list);
                }
                list.add(nonCodeUsage);
            }
        }
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        }
        if (this.myMoveCallback != null) {
            if (this.myMoveCallback instanceof MoveClassesOrPackagesCallback) {
                ((MoveClassesOrPackagesCallback)this.myMoveCallback).classesMovedToInner(this.myTargetClass);
            }
            this.myMoveCallback.refactoringCompleted();
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"move.class.to.inner.command.name", (Object[])new Object[]{(this.myClassesToMove.length > 1 ? "classes " : "class ") + StringUtil.join((Object[])this.myClassesToMove, psiClass -> psiClass.getName(), (String)", "), this.myTargetClass.getQualifiedName()});
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        result2.addAll(super.getElementsToWrite(descriptor));
        result2.add(this.myTargetClass);
        return result2;
    }

    public MultiMap<PsiElement, String> getConflicts(UsageInfo[] usages) {
        MultiMap conflicts = new MultiMap();
        for (PsiClass classToMove : this.myClassesToMove) {
            PsiClass innerClass = this.myTargetClass.findInnerClassByName(classToMove.getName(), false);
            if (innerClass == null) continue;
            conflicts.putValue((Object)innerClass, (Object)RefactoringBundle.message((String)"move.to.inner.duplicate.inner.class", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)this.myTargetClass.getQualifiedName()), CommonRefactoringUtil.htmlEmphasize((String)classToMove.getName())}));
        }
        for (int i2 = 0; i2 < this.myClassesToMove.length; ++i2) {
            boolean moveToOtherPackage;
            PsiClass classToMove = this.myClassesToMove[i2];
            String classToMoveVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)classToMove.getModifierList());
            String targetClassVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myTargetClass.getModifierList());
            boolean bl = moveToOtherPackage = !Comparing.equal((Object)this.mySourcePackage[i2], (Object)this.myTargetPackage);
            if (moveToOtherPackage) {
                classToMove.accept((PsiElementVisitor)new PackageLocalsUsageCollector((PsiElement[])this.myClassesToMove, new PackageWrapper(this.myTargetPackage), (MultiMap<PsiElement, String>)conflicts));
            }
            ConflictsCollector collector = new ConflictsCollector(classToMove, (MultiMap<PsiElement, String>)conflicts);
            if (moveToOtherPackage && (classToMoveVisibility.equals("packageLocal") || targetClassVisibility.equals("packageLocal")) || targetClassVisibility.equals("private")) {
                this.detectInaccessibleClassUsages(usages, collector, this.mySourceVisibility[i2]);
            }
            if (!moveToOtherPackage) continue;
            this.detectInaccessibleMemberUsages(collector);
        }
        return conflicts;
    }

    private void detectInaccessibleClassUsages(UsageInfo[] usages, ConflictsCollector collector, String visibility) {
        for (UsageInfo usage : usages) {
            PsiElement element;
            if (!(usage instanceof MoveRenameUsageInfo) || usage instanceof NonCodeUsageInfo || (element = usage.getElement()) == null || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class) != null || !this.isInaccessibleFromTarget(element, visibility)) continue;
            collector.addConflict(collector.getClassToMove(), element);
        }
    }

    private boolean isInaccessibleFromTarget(PsiElement element, String visibility) {
        PsiPackage elementPackage = JavaDirectoryService.getInstance().getPackage(element.getContainingFile().getContainingDirectory());
        return !PsiUtil.isAccessible((PsiMember)this.myTargetClass, (PsiElement)element, null) || !this.myTargetClass.isInterface() && visibility.equals("packageLocal") && !Comparing.equal((Object)elementPackage, (Object)this.myTargetPackage);
    }

    private void detectInaccessibleMemberUsages(ConflictsCollector collector) {
        PsiElement[] members;
        for (PsiElement member : members = MoveClassToInnerProcessor.collectPackageLocalMembers(collector.getClassToMove())) {
            ReferencesSearch.search((PsiElement)member).forEach(psiReference -> {
                PsiElement element = psiReference.getElement();
                for (PsiClass psiClass : this.myClassesToMove) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)psiClass, (PsiElement)element, (boolean)false)) continue;
                    return true;
                }
                if (this.isInaccessibleFromTarget(element, "packageLocal")) {
                    collector.addConflict(psiReference.resolve(), element);
                }
                return true;
            });
        }
    }

    private static PsiElement[] collectPackageLocalMembers(PsiElement classToMove) {
        return PsiTreeUtil.collectElements((PsiElement)classToMove, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                PsiMember member;
                return element instanceof PsiMember && VisibilityUtil.getVisibilityModifier((PsiModifierList)(member = (PsiMember)element).getModifierList()) == "packageLocal";
            }
        });
    }

    public void setOpenInEditor(boolean openInEditor) {
        this.myOpenInEditor = openInEditor;
    }

    private static class ConflictsCollector {
        private final PsiClass myClassToMove;
        private final MultiMap<PsiElement, String> myConflicts;
        private final Set<PsiElement> myReportedContainers = new HashSet<PsiElement>();

        public ConflictsCollector(PsiClass classToMove, MultiMap<PsiElement, String> conflicts) {
            this.myClassToMove = classToMove;
            this.myConflicts = conflicts;
        }

        public synchronized void addConflict(PsiElement targetElement, PsiElement sourceElement) {
            PsiElement container = ConflictsUtil.getContainer(sourceElement);
            if (!this.myReportedContainers.contains(container)) {
                this.myReportedContainers.add(container);
                String targetDescription = targetElement == this.myClassToMove ? "Class " + CommonRefactoringUtil.htmlEmphasize((String)this.myClassToMove.getName()) : StringUtil.capitalize((String)RefactoringUIUtil.getDescription(targetElement, true));
                String message2 = RefactoringBundle.message((String)"element.will.no.longer.be.accessible", (Object[])new Object[]{targetDescription, RefactoringUIUtil.getDescription(container, true)});
                this.myConflicts.putValue((Object)targetElement, (Object)message2);
            }
        }

        public PsiElement getClassToMove() {
            return this.myClassToMove;
        }
    }
}

