/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveFilesOrDirectoriesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil");

    private MoveFilesOrDirectoriesUtil() {
    }

    public static void doMoveDirectory(PsiDirectory aDirectory, PsiDirectory destDirectory) throws IncorrectOperationException {
        PsiManager manager = aDirectory.getManager();
        MoveFilesOrDirectoriesUtil.checkMove((PsiElement)aDirectory, (PsiElement)destDirectory);
        try {
            aDirectory.getVirtualFile().move((Object)manager, destDirectory.getVirtualFile());
        }
        catch (IOException e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        DumbService.getInstance((Project)manager.getProject()).completeJustSubmittedTasks();
    }

    public static void doMoveFile(@NotNull PsiFile file2, @NotNull PsiDirectory newDirectory) throws IncorrectOperationException {
        if (!newDirectory.equals(file2.getContainingDirectory())) {
            MoveFilesOrDirectoriesUtil.checkMove((PsiElement)file2, (PsiElement)newDirectory);
            VirtualFile vFile = file2.getVirtualFile();
            if (vFile == null) {
                throw new IncorrectOperationException("Non-physical file: " + file2 + " (" + file2.getClass() + ")");
            }
            try {
                vFile.move((Object)file2.getManager(), newDirectory.getVirtualFile());
            }
            catch (IOException e) {
                throw new IncorrectOperationException((Throwable)e);
            }
        }
    }

    public static void doMove(Project project2, PsiElement[] elements, PsiElement[] targetElement, MoveCallback moveCallback) {
        MoveFilesOrDirectoriesUtil.doMove(project2, elements, targetElement, moveCallback, null);
    }

    public static void doMove(final Project project2, final PsiElement[] elements, final PsiElement[] targetElement, final MoveCallback moveCallback, Function<PsiElement[], PsiElement[]> adjustElements) {
        if (adjustElements == null) {
            for (PsiElement element : elements) {
                if (element instanceof PsiFile || element instanceof PsiDirectory) continue;
                throw new IllegalArgumentException("unexpected element type: " + element);
            }
        }
        PsiDirectory targetDirectory = MoveFilesOrDirectoriesUtil.resolveToDirectory(project2, targetElement[0]);
        if (targetElement[0] != null && targetDirectory == null) {
            return;
        }
        final PsiElement[] newElements = adjustElements != null ? (PsiElement[])adjustElements.fun((Object)elements) : elements;
        final PsiDirectory initialTargetDirectory = MoveFilesOrDirectoriesUtil.getInitialTargetDirectory(targetDirectory, elements);
        MoveFilesOrDirectoriesDialog.Callback doRun = new MoveFilesOrDirectoriesDialog.Callback(){

            @Override
            public void run(MoveFilesOrDirectoriesDialog moveDialog) {
                CommandProcessor.getInstance().executeCommand(project2, () -> {
                    PsiDirectory targetDirectory1;
                    PsiDirectory psiDirectory = targetDirectory1 = moveDialog != null ? moveDialog.getTargetDirectory() : initialTargetDirectory;
                    if (targetDirectory1 == null) {
                        LOG.error("It is null! The target directory, it is null!");
                        return;
                    }
                    ArrayList toCheck = ContainerUtil.newArrayList((Object[])new PsiElement[]{targetDirectory1});
                    for (PsiElement e : newElements) {
                        toCheck.add(e instanceof PsiFileSystemItem && e.getParent() != null ? e.getParent() : e);
                    }
                    if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (Collection)toCheck, (boolean)false)) {
                        return;
                    }
                    targetElement2[0] = targetDirectory1;
                    try {
                        int[] nArray;
                        if (elements.length > 1 || elements[0] instanceof PsiDirectory) {
                            int[] nArray2 = new int[1];
                            nArray = nArray2;
                            nArray2[0] = -1;
                        } else {
                            nArray = null;
                        }
                        int[] choice = nArray;
                        ArrayList<PsiElement> els = new ArrayList<PsiElement>();
                        for (PsiElement psiElement : newElements) {
                            PsiFile file2;
                            if (psiElement instanceof PsiFile && CopyFilesOrDirectoriesHandler.checkFileExist(targetDirectory1, choice, file2 = (PsiFile)psiElement, file2.getName(), "Move")) continue;
                            MoveFilesOrDirectoriesUtil.checkMove(psiElement, (PsiElement)targetDirectory1);
                            els.add(psiElement);
                        }
                        Runnable callback = () -> {
                            if (moveDialog != null) {
                                moveDialog.close(1);
                            }
                        };
                        if (els.isEmpty()) {
                            callback.run();
                            return;
                        }
                        new MoveFilesOrDirectoriesProcessor(project2, els.toArray(new PsiElement[els.size()]), targetDirectory1, RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE, false, false, moveCallback, callback).run();
                    }
                    catch (IncorrectOperationException e) {
                        CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), (String)"refactoring.moveFile", (Project)project2);
                    }
                }, MoveHandler.REFACTORING_NAME, null);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            doRun.run(null);
        } else {
            MoveFilesOrDirectoriesDialog moveDialog = new MoveFilesOrDirectoriesDialog(project2, doRun);
            moveDialog.setData(newElements, initialTargetDirectory, "refactoring.moveFile");
            moveDialog.show();
        }
    }

    @Nullable
    public static PsiDirectory resolveToDirectory(Project project2, PsiElement element) {
        if (!(element instanceof PsiDirectoryContainer)) {
            return (PsiDirectory)element;
        }
        PsiDirectory[] directories = ((PsiDirectoryContainer)element).getDirectories();
        switch (directories.length) {
            case 0: {
                return null;
            }
            case 1: {
                return directories[0];
            }
        }
        return DirectoryChooserUtil.chooseDirectory(directories, directories[0], project2, new HashMap<PsiDirectory, String>());
    }

    @Nullable
    private static PsiDirectory getCommonDirectory(PsiElement[] movedElements) {
        PsiDirectory commonDirectory = null;
        for (PsiElement movedElement : movedElements) {
            PsiDirectory containingDirectory;
            if (movedElement instanceof PsiDirectory) {
                containingDirectory = ((PsiDirectory)movedElement).getParentDirectory();
            } else {
                PsiFile containingFile = movedElement.getContainingFile();
                PsiDirectory psiDirectory = containingDirectory = containingFile == null ? null : containingFile.getContainingDirectory();
            }
            if (containingDirectory == null) continue;
            if (commonDirectory == null) {
                commonDirectory = containingDirectory;
                continue;
            }
            if (commonDirectory == containingDirectory) continue;
            return null;
        }
        return commonDirectory;
    }

    @Nullable
    public static PsiDirectory getInitialTargetDirectory(PsiDirectory initialTargetElement, PsiElement[] movedElements) {
        PsiDirectory initialTargetDirectory = initialTargetElement;
        if (initialTargetDirectory == null && movedElements != null) {
            PsiDirectory commonDirectory = MoveFilesOrDirectoriesUtil.getCommonDirectory(movedElements);
            initialTargetDirectory = commonDirectory != null ? commonDirectory : MoveFilesOrDirectoriesUtil.getContainerDirectory(movedElements[0]);
        }
        return initialTargetDirectory;
    }

    @Nullable
    private static PsiDirectory getContainerDirectory(PsiElement psiElement) {
        if (psiElement instanceof PsiDirectory) {
            return (PsiDirectory)psiElement;
        }
        if (psiElement != null) {
            return psiElement.getContainingFile().getContainingDirectory();
        }
        return null;
    }

    public static void checkMove(@NotNull PsiElement element, @NotNull PsiElement newContainer) throws IncorrectOperationException {
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] dirs = ((PsiDirectoryContainer)element).getDirectories();
            if (dirs.length == 0) {
                throw new IncorrectOperationException();
            }
            if (dirs.length > 1) {
                throw new IncorrectOperationException("Moving of packages represented by more than one physical directory is not supported.");
            }
            MoveFilesOrDirectoriesUtil.checkMove((PsiElement)dirs[0], newContainer);
            return;
        }
        newContainer.checkAdd(element);
        MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf(element, newContainer);
    }

    public static void checkIfMoveIntoSelf(PsiElement element, PsiElement newContainer) throws IncorrectOperationException {
        for (PsiElement container = newContainer; container != null; container = container.getParent()) {
            if (container != element) continue;
            if (element instanceof PsiDirectory) {
                if (element == newContainer) {
                    throw new IncorrectOperationException("Cannot place directory into itself.");
                }
                throw new IncorrectOperationException("Cannot place directory into its subdirectory.");
            }
            throw new IncorrectOperationException();
        }
    }
}

