/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveInner.MoveInnerDialog;
import com.intellij.refactoring.move.moveInner.MoveInnerProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.Nullable;

public class MoveInnerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveInner.MoveInnerImpl");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"move.inner.to.upper.level.title");

    public static void doMove(Project project2, PsiElement[] elements, MoveCallback moveCallback, @Nullable PsiElement targetContainer) {
        if (elements.length != 1) {
            return;
        }
        PsiClass aClass = (PsiClass)elements[0];
        boolean condition2 = aClass.getContainingClass() != null;
        LOG.assertTrue(condition2);
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)aClass)) {
            return;
        }
        if (targetContainer == null) {
            targetContainer = MoveInnerImpl.getTargetContainer(aClass, true);
        }
        if (targetContainer == null) {
            return;
        }
        MoveInnerDialog dialog2 = new MoveInnerDialog(project2, aClass, new MoveInnerProcessor(project2, moveCallback), targetContainer);
        dialog2.show();
    }

    @Nullable
    public static PsiElement getTargetContainer(PsiClass innerClass, boolean chooseIfNotUnderSource) {
        PsiClass outerClass = innerClass.getContainingClass();
        assert (outerClass != null);
        for (PsiElement outerClassParent = outerClass.getParent(); outerClassParent != null; outerClassParent = outerClassParent.getParent()) {
            if (outerClassParent instanceof PsiClass && !(outerClassParent instanceof PsiAnonymousClass)) {
                return outerClassParent;
            }
            if (!(outerClassParent instanceof PsiFile)) continue;
            PsiDirectory directory = innerClass.getContainingFile().getContainingDirectory();
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null) {
                if (chooseIfNotUnderSource) {
                    PackageChooserDialog chooser = new PackageChooserDialog("Select Target Package", innerClass.getProject());
                    if (!chooser.showAndGet()) {
                        return null;
                    }
                    PsiPackage chosenPackage = chooser.getSelectedPackage();
                    if (chosenPackage == null) {
                        return null;
                    }
                    return chosenPackage.getDirectories()[0];
                }
                return null;
            }
            return directory;
        }
        LOG.assertTrue(false);
        return null;
    }
}

