/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInstanceMethod;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.makeStatic.MakeStaticHandler;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveInstanceMethodHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodHandler");
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"move.instance.method.title");

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file2.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (!(element instanceof PsiMethod)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.moveInstMethod");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Move Instance Method invoked");
        }
        this.invoke(project2, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (elements.length != 1 || !(elements[0] instanceof PsiMethod)) {
            return;
        }
        PsiMethod method2 = (PsiMethod)elements[0];
        String message2 = null;
        if (!method2.getManager().isInProject((PsiElement)method2)) {
            message2 = "Move method is not supported for non-project methods";
        } else if (method2.isConstructor()) {
            message2 = RefactoringBundle.message((String)"move.method.is.not.supported.for.constructors");
        } else if (method2.getLanguage() != JavaLanguage.INSTANCE) {
            message2 = RefactoringBundle.message((String)"move.method.is.not.supported.for.0", (Object[])new Object[]{method2.getLanguage().getDisplayName()});
        } else {
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass != null && PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)containingClass).hasNext() && TypeParametersSearcher.hasTypeParameters((PsiElement)method2)) {
                message2 = RefactoringBundle.message((String)"move.method.is.not.supported.for.generic.classes");
            } else if (method2.findSuperMethods().length > 0 || ((PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method2).toArray((Object[])PsiMethod.EMPTY_ARRAY)).length > 0) {
                message2 = RefactoringBundle.message((String)"move.method.is.not.supported.when.method.is.part.of.inheritance.hierarchy");
            } else {
                Set<PsiClass> classes2 = MoveInstanceMembersUtil.getThisClassesToMembers((PsiMember)method2).keySet();
                for (PsiClass aClass : classes2) {
                    if (!(aClass instanceof JspClass)) continue;
                    message2 = RefactoringBundle.message((String)"synthetic.jsp.class.is.referenced.in.the.method");
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.moveInstMethod");
                    break;
                }
            }
        }
        if (message2 != null) {
            MoveInstanceMethodHandler.showErrorHint(project2, dataContext, message2);
            return;
        }
        ArrayList<PsiVariable> suitableVariables = new ArrayList<PsiVariable>();
        message2 = MoveInstanceMethodHandler.collectSuitableVariables(method2, suitableVariables);
        if (message2 != null) {
            String unableToMakeStaticMessage = MakeStaticHandler.validateTarget((PsiTypeParameterListOwner)method2);
            if (unableToMakeStaticMessage != null) {
                MoveInstanceMethodHandler.showErrorHint(project2, dataContext, message2);
            } else {
                String suggestToMakeStaticMessage = "Would you like to make method '" + method2.getName() + "' static and then move?";
                if (Messages.showYesNoCancelDialog((Project)project2, (String)(message2 + ". " + suggestToMakeStaticMessage), (String)REFACTORING_NAME, (Icon)Messages.getErrorIcon()) == 0) {
                    MakeStaticHandler.invoke((PsiTypeParameterListOwner)method2);
                }
            }
            return;
        }
        new MoveInstanceMethodDialog(method2, suitableVariables.toArray(new PsiVariable[suitableVariables.size()])).show();
    }

    private static void showErrorHint(Project project2, DataContext dataContext, String message2) {
        Editor editor = dataContext == null ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)message2), (String)REFACTORING_NAME, (String)"refactoring.moveInstMethod");
    }

    @Nullable
    private static String collectSuitableVariables(PsiMethod method2, List<PsiVariable> suitableVariables) {
        ArrayList allVariables = new ArrayList();
        ContainerUtil.addAll(allVariables, (Object[])method2.getParameterList().getParameters());
        ContainerUtil.addAll(allVariables, (Object[])method2.getContainingClass().getFields());
        boolean classTypesFound = false;
        boolean resolvableClassesFound = false;
        boolean classesInProjectFound = false;
        for (PsiVariable variable : allVariables) {
            PsiType type2 = variable.getType();
            if (!(type2 instanceof PsiClassType) || ((PsiClassType)type2).hasParameters()) continue;
            classTypesFound = true;
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            if (psiClass == null || psiClass instanceof PsiTypeParameter) continue;
            resolvableClassesFound = true;
            boolean inProject = method2.getManager().isInProject((PsiElement)psiClass);
            if (!inProject) continue;
            classesInProjectFound = true;
            suitableVariables.add(variable);
        }
        if (suitableVariables.isEmpty()) {
            if (!classTypesFound) {
                return RefactoringBundle.message((String)"there.are.no.variables.that.have.reference.type");
            }
            if (!resolvableClassesFound) {
                return RefactoringBundle.message((String)"all.candidate.variables.have.unknown.types");
            }
            if (!classesInProjectFound) {
                return RefactoringBundle.message((String)"all.candidate.variables.have.types.not.in.project");
            }
        }
        return null;
    }

    public static String suggestParameterNameForThisClass(PsiClass thisClass) {
        PsiManager manager = thisClass.getManager();
        PsiClassType type2 = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType(thisClass);
        SuggestedNameInfo suggestedNameInfo = JavaCodeStyleManager.getInstance((Project)manager.getProject()).suggestVariableName(VariableKind.PARAMETER, null, null, (PsiType)type2);
        return suggestedNameInfo.names.length > 0 ? suggestedNameInfo.names[0] : "";
    }

    public static Map<PsiClass, String> suggestParameterNames(PsiMethod method2, PsiVariable targetVariable) {
        Map<PsiClass, Set<PsiMember>> classesToMembers = MoveInstanceMembersUtil.getThisClassesToMembers((PsiMember)method2);
        LinkedHashMap<PsiClass, String> result2 = new LinkedHashMap<PsiClass, String>();
        for (Map.Entry<PsiClass, Set<PsiMember>> entry : classesToMembers.entrySet()) {
            PsiClass aClass = entry.getKey();
            Set<PsiMember> members = entry.getValue();
            if (members.size() == 1 && members.contains(targetVariable)) continue;
            result2.put(aClass, MoveInstanceMethodHandler.suggestParameterNameForThisClass(aClass));
        }
        return result2;
    }

    private static class TypeParametersSearcher
    extends PsiTypeVisitor<Boolean> {
        private TypeParametersSearcher() {
        }

        public static boolean hasTypeParameters(PsiElement element) {
            final TypeParametersSearcher searcher = new TypeParametersSearcher();
            final boolean[] hasParameters = new boolean[]{false};
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitTypeElement(PsiTypeElement type2) {
                    super.visitTypeElement(type2);
                    hasParameters[0] = hasParameters[0] | (Boolean)type2.getType().accept((PsiTypeVisitor)searcher);
                }
            });
            return hasParameters[0];
        }

        public Boolean visitClassType(PsiClassType classType) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)classType);
            if (psiClass instanceof PsiTypeParameter) {
                return Boolean.TRUE;
            }
            return (Boolean)super.visitClassType(classType);
        }

        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (PsiUtil.resolveClassInType((PsiType)bound) instanceof PsiTypeParameter) {
                return Boolean.TRUE;
            }
            return (Boolean)super.visitWildcardType(wildcardType);
        }

        public Boolean visitType(PsiType type2) {
            return Boolean.FALSE;
        }
    }
}

