/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class RelatedFilesRenamer
extends AutomaticRenamer {
    private static final Logger LOG = Logger.getInstance((String)RelatedFilesRenamer.class.getName());

    public RelatedFilesRenamer(@NotNull PsiFile psiFile, @NotNull String newName) {
        Collection<NestingTreeStructureProvider.ChildFileInfo> relatedFileInfos = NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(psiFile.getProject(), psiFile.getVirtualFile());
        for (NestingTreeStructureProvider.ChildFileInfo info : relatedFileInfos) {
            PsiFile relatedPsiFile = psiFile.getManager().findFile(info.file);
            if (relatedPsiFile == null) continue;
            LOG.assertTrue(psiFile.getName().startsWith(info.namePartCommonWithParentFile) && relatedPsiFile.getName().startsWith(info.namePartCommonWithParentFile), (Object)(psiFile.getName() + "," + relatedPsiFile.getName() + "," + info.namePartCommonWithParentFile));
            String suffix = psiFile.getName().substring(info.namePartCommonWithParentFile.length());
            LOG.assertTrue(suffix.length() > 0, (Object)(psiFile.getName() + "," + info.namePartCommonWithParentFile));
            if (!newName.endsWith(suffix)) continue;
            String newRelatedFileName = newName.substring(0, newName.length() - suffix.length()) + relatedPsiFile.getName().substring(info.namePartCommonWithParentFile.length());
            this.myElements.add(relatedPsiFile);
            this.suggestAllNames(relatedPsiFile.getName(), newRelatedFileName);
        }
    }

    @Override
    public boolean isSelectedByDefault() {
        return true;
    }

    @Override
    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.title");
    }

    @Override
    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.related.file.dialog.description");
    }

    @Override
    public String entityName() {
        return RefactoringBundle.message((String)"related.file");
    }
}

