/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.ClassHidesImportedClassUsageInfo;
import com.intellij.refactoring.rename.ClassHidesUnqualifiableClassUsageInfo;
import com.intellij.refactoring.rename.CollidingClassImportUsageInfo;
import com.intellij.refactoring.rename.MemberHidesOuterMemberUsageInfo;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.ResolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.SubmemberHidesMemberUsageInfo;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameJavaClassProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameJavaClassProcessor");
    @NonNls
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s");

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof PsiClass;
    }

    @Override
    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        PsiClass aClass = (PsiClass)element;
        ArrayList<UsageInfo> postponedCollisions = new ArrayList<UsageInfo>();
        ArrayList<MemberHidesOuterMemberUsageInfo> hidesOut = new ArrayList<MemberHidesOuterMemberUsageInfo>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof ResolvableCollisionUsageInfo)) continue;
            if (usage instanceof CollidingClassImportUsageInfo) {
                ((CollidingClassImportUsageInfo)usage).getImportStatement().delete();
                continue;
            }
            if (usage instanceof MemberHidesOuterMemberUsageInfo) {
                PsiElement usageElement = usage.getElement();
                PsiJavaCodeReferenceElement collidingRef = (PsiJavaCodeReferenceElement)usageElement;
                if (collidingRef == null) continue;
                hidesOut.add(new MemberHidesOuterMemberUsageInfo(usageElement, (PsiMember)((PsiClass)collidingRef.resolve())));
                continue;
            }
            postponedCollisions.add(usage);
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)aClass.getContainingFile(), true, false);
        aClass.setName(newName);
        for (UsageInfo usage : usages) {
            PsiReference ref;
            if (usage instanceof ResolvableCollisionUsageInfo || (ref = usage.getReference()) == null) continue;
            try {
                ref.bindToElement((PsiElement)aClass);
            }
            catch (IncorrectOperationException e) {
                ref.handleElementRename(newName);
            }
        }
        ChangeContextUtil.decodeContextInfo((PsiElement)aClass.getContainingFile(), null, null);
        for (UsageInfo postponedCollision : postponedCollisions) {
            ClassHidesImportedClassUsageInfo collision = (ClassHidesImportedClassUsageInfo)postponedCollision;
            collision.resolveCollision();
        }
        for (MemberHidesOuterMemberUsageInfo usage : hidesOut) {
            PsiJavaCodeReferenceElement collidingRef = (PsiJavaCodeReferenceElement)usage.getElement();
            PsiMember member = (PsiMember)usage.getReferencedElement();
            if (collidingRef == null || !collidingRef.isValid() || member == null || !member.isValid()) continue;
            PsiManager manager = member.getManager();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)member.getProject());
            String name = member.getName();
            PsiClass containingClass = member.getContainingClass();
            if (name == null || containingClass == null || manager.areElementsEquivalent(factory.createReferenceFromText(name, (PsiElement)collidingRef).resolve(), (PsiElement)member)) continue;
            PsiJavaCodeReferenceElement ref = factory.createReferenceFromText("A." + name, (PsiElement)collidingRef);
            PsiJavaCodeReferenceElement qualifier = (PsiJavaCodeReferenceElement)ref.getQualifier();
            LOG.assertTrue(qualifier != null);
            PsiJavaCodeReferenceElement classReference2 = factory.createClassReferenceElement(containingClass);
            qualifier.replace((PsiElement)classReference2);
            collidingRef.replace((PsiElement)ref);
        }
        if (listener2 != null) {
            listener2.elementRenamed((PsiElement)aClass);
        }
    }

    @Override
    @Nullable
    public Pair<String, String> getTextOccurrenceSearchStrings(@NotNull PsiElement element, @NotNull String newName) {
        PsiClass aClass;
        if (element instanceof PsiClass && (aClass = (PsiClass)element).getParent() instanceof PsiClass) {
            String dollaredStringToReplace;
            String dollaredStringToSearch = ClassUtil.getJVMClassName((PsiClass)aClass);
            String string = dollaredStringToReplace = dollaredStringToSearch == null ? null : RefactoringUtil.getNewInnerClassName(aClass, dollaredStringToSearch, newName);
            if (dollaredStringToReplace != null) {
                return Pair.create((Object)dollaredStringToSearch, (Object)dollaredStringToReplace);
            }
        }
        return null;
    }

    @Override
    public String getQualifiedNameAfterRename(PsiElement element, String newName, boolean nonJava) {
        if (nonJava) {
            PsiClass aClass = (PsiClass)element;
            return PsiUtilCore.getQualifiedNameAfterRename((String)aClass.getQualifiedName(), (String)newName);
        }
        return newName;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = ((PsiClass)element).getConstructors()) {
            if (constructor instanceof PsiMirrorElement) {
                PsiElement prototype = ((PsiMirrorElement)constructor).getPrototype();
                if (!(prototype instanceof PsiNamedElement)) continue;
                allRenames.put(prototype, newName);
                continue;
            }
            if (constructor instanceof LightElement) continue;
            allRenames.put((PsiElement)constructor, newName);
        }
    }

    @Override
    public void findCollisions(PsiElement element, final String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result2) {
        PsiTypeParameterListOwner owner;
        final PsiClass aClass = (PsiClass)element;
        ClassCollisionsDetector classCollisionsDetector = new ClassCollisionsDetector(aClass);
        ArrayList<UsageInfo> initialResults = new ArrayList<UsageInfo>(result2);
        for (UsageInfo usageInfo : initialResults) {
            if (!(usageInfo instanceof MoveRenameUsageInfo)) continue;
            classCollisionsDetector.addClassCollisions(usageInfo.getElement(), newName, result2);
        }
        RenameJavaClassProcessor.findSubmemberHidesMemberCollisions(aClass, newName, result2);
        if (aClass instanceof PsiTypeParameter && (owner = ((PsiTypeParameter)aClass).getOwner()) != null) {
            for (PsiTypeParameter typeParameter : owner.getTypeParameters()) {
                if (!Comparing.equal((String)newName, (String)typeParameter.getName())) continue;
                result2.add((UsageInfo)new UnresolvableCollisionUsageInfo((PsiElement)aClass, (PsiElement)typeParameter){

                    @Override
                    public String getDescription() {
                        return "There is already type parameter in " + RefactoringUIUtil.getDescription((PsiElement)aClass, false) + " with name " + newName;
                    }
                });
            }
        }
    }

    public static void findSubmemberHidesMemberCollisions(PsiClass aClass, String newName, List<UsageInfo> result2) {
        block9: {
            PsiClass[] supers;
            PsiTypeParameterListOwner owner;
            block8: {
                if (!(aClass.getParent() instanceof PsiClass)) break block8;
                PsiClass parent = (PsiClass)aClass.getParent();
                Collection inheritors = ClassInheritorsSearch.search((PsiClass)parent).findAll();
                for (PsiClass inheritor : inheritors) {
                    if (newName.equals(inheritor.getName())) {
                        ClassCollisionsDetector classCollisionsDetector = new ClassCollisionsDetector(aClass);
                        for (PsiReference reference2 : ReferencesSearch.search((PsiElement)inheritor, (SearchScope)new LocalSearchScope((PsiElement)inheritor))) {
                            classCollisionsDetector.addClassCollisions(reference2.getElement(), newName, result2);
                        }
                    }
                    PsiClass[] inners = inheritor.getInnerClasses();
                    for (PsiClass inner : inners) {
                        if (!newName.equals(inner.getName())) continue;
                        result2.add((UsageInfo)new SubmemberHidesMemberUsageInfo((PsiElement)inner, (PsiElement)aClass));
                    }
                }
                break block9;
            }
            if (!(aClass instanceof PsiTypeParameter) || !((owner = ((PsiTypeParameter)aClass).getOwner()) instanceof PsiClass)) break block9;
            for (PsiClass superClass : supers = ((PsiClass)owner).getSupers()) {
                if (newName.equals(superClass.getName())) {
                    ClassCollisionsDetector classCollisionsDetector = new ClassCollisionsDetector(aClass);
                    for (PsiReference reference3 : ReferencesSearch.search((PsiElement)superClass, (SearchScope)new LocalSearchScope((PsiElement)superClass))) {
                        classCollisionsDetector.addClassCollisions(reference3.getElement(), newName, result2);
                    }
                }
                PsiClass[] inners = superClass.getInnerClasses();
                for (PsiClass inner : inners) {
                    if (!newName.equals(inner.getName())) continue;
                    ReferencesSearch.search((PsiElement)inner).forEach(reference -> {
                        PsiElement refElement = reference.getElement();
                        if (refElement instanceof PsiReferenceExpression && ((PsiReferenceExpression)refElement).isQualified()) {
                            return true;
                        }
                        MemberHidesOuterMemberUsageInfo info = new MemberHidesOuterMemberUsageInfo(refElement, (PsiMember)aClass);
                        result2.add((UsageInfo)info);
                        return true;
                    });
                }
            }
        }
    }

    private static String removeSpaces(String s) {
        return WHITE_SPACE_PATTERN.matcher(s).replaceAll("");
    }

    @Override
    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
        if (element instanceof PsiCompiledElement) {
            return;
        }
        PsiClass aClass = (PsiClass)element;
        if (newName.equals(aClass.getName())) {
            return;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null) {
            PsiClass[] innerClasses;
            for (PsiClass innerClass : innerClasses = containingClass.getInnerClasses()) {
                if (!newName.equals(innerClass.getName())) continue;
                conflicts.putValue((Object)innerClass, (Object)RefactoringBundle.message((String)"inner.class.0.is.already.defined.in.class.1", (Object[])new Object[]{newName, containingClass.getQualifiedName()}));
                break;
            }
        } else if (!(aClass instanceof PsiTypeParameter)) {
            String qualifiedNameAfterRename = PsiUtilCore.getQualifiedNameAfterRename((String)aClass.getQualifiedName(), (String)newName);
            Project project2 = element.getProject();
            PsiClass conflictingClass = JavaPsiFacade.getInstance((Project)project2).findClass(qualifiedNameAfterRename, GlobalSearchScope.allScope((Project)project2));
            if (conflictingClass != null) {
                conflicts.putValue((Object)conflictingClass, (Object)RefactoringBundle.message((String)"class.0.already.exists", (Object[])new Object[]{qualifiedNameAfterRename}));
            }
        }
    }

    @Override
    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameClass";
    }

    @Override
    public boolean isToSearchInComments(PsiElement psiElement) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS = enabled;
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS = enabled;
    }

    private static class ClassCollisionsDetector {
        final HashSet<PsiFile> myProcessedFiles = new HashSet();
        final PsiClass myRenamedClass;
        private final String myRenamedClassQualifiedName;

        public ClassCollisionsDetector(PsiClass renamedClass) {
            this.myRenamedClass = renamedClass;
            this.myRenamedClassQualifiedName = this.myRenamedClass.getQualifiedName();
        }

        public void addClassCollisions(PsiElement referenceElement, String newName, List<UsageInfo> results) {
            PsiTypeParameterList typeParameterList;
            PsiTypeParameterListOwner member;
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)referenceElement.getProject()).getResolveHelper();
            PsiClass aClass = resolveHelper.resolveReferencedClass(newName, referenceElement);
            if (aClass == null) {
                return;
            }
            if (aClass instanceof PsiTypeParameter && this.myRenamedClass instanceof PsiTypeParameter && (member = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiTypeParameterListOwner.class)) != null && (typeParameterList = member.getTypeParameterList()) != null && ArrayUtilRt.find((Object[])typeParameterList.getTypeParameters(), (Object)this.myRenamedClass) > -1 && member.hasModifierProperty("static")) {
                return;
            }
            PsiFile containingFile = referenceElement.getContainingFile();
            String text = referenceElement.getText();
            if (Comparing.equal((String)this.myRenamedClassQualifiedName, (String)RenameJavaClassProcessor.removeSpaces(text))) {
                return;
            }
            if (this.myProcessedFiles.contains(containingFile)) {
                return;
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)new LocalSearchScope((PsiElement)containingFile))) {
                PsiElement collisionReferenceElement = reference.getElement();
                if (!(collisionReferenceElement instanceof PsiJavaCodeReferenceElement)) continue;
                PsiElement parent = collisionReferenceElement.getParent();
                if (parent instanceof PsiImportStatement) {
                    results.add((UsageInfo)new CollidingClassImportUsageInfo((PsiImportStatement)parent, (PsiElement)this.myRenamedClass));
                    continue;
                }
                if (aClass.getQualifiedName() != null) {
                    results.add((UsageInfo)new ClassHidesImportedClassUsageInfo((PsiJavaCodeReferenceElement)collisionReferenceElement, this.myRenamedClass, aClass));
                    continue;
                }
                results.add((UsageInfo)new ClassHidesUnqualifiableClassUsageInfo((PsiJavaCodeReferenceElement)collisionReferenceElement, this.myRenamedClass, aClass));
            }
            this.myProcessedFiles.add(containingFile);
        }
    }
}

