/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.MemberHidesOuterMemberUsageInfo;
import com.intellij.refactoring.rename.MemberHidesStaticImportUsageInfo;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class RenameJavaMemberProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameJavaMemberProcessor");

    public static void qualifyMember(PsiMember member, PsiElement occurence, String newName) throws IncorrectOperationException {
        PsiClass containingClass = member.getContainingClass();
        if (containingClass != null) {
            RenameJavaMemberProcessor.qualifyMember(occurence, newName, containingClass, member.hasModifierProperty("static"));
        }
    }

    protected static void qualifyMember(PsiElement occurence, String newName, @NotNull PsiClass containingClass, boolean isStatic) throws IncorrectOperationException {
        PsiManager psiManager = occurence.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        if (isStatic) {
            PsiReferenceExpression qualified = (PsiReferenceExpression)factory.createExpressionFromText("a." + newName, null);
            qualified = (PsiReferenceExpression)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)qualified);
            qualified.getQualifierExpression().replace((PsiElement)factory.createReferenceExpression(containingClass));
            occurence.replace((PsiElement)qualified);
        } else {
            PsiReferenceExpression qualified = RenameJavaMemberProcessor.createQualifiedMemberReference(occurence, newName, containingClass, isStatic);
            qualified = (PsiReferenceExpression)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)qualified);
            occurence.replace((PsiElement)qualified);
        }
    }

    public static PsiReferenceExpression createMemberReference(PsiMember member, PsiElement context) throws IncorrectOperationException {
        PsiManager manager = member.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String name = member.getName();
        PsiReferenceExpression ref = (PsiReferenceExpression)factory.createExpressionFromText(name, context);
        PsiElement resolved = ref.resolve();
        PsiClass containingClass = member.getContainingClass();
        if (manager.areElementsEquivalent(resolved, (PsiElement)member) || containingClass == null) {
            return ref;
        }
        return RenameJavaMemberProcessor.createQualifiedMemberReference(context, name, containingClass, member.hasModifierProperty("static"));
    }

    protected static PsiReferenceExpression createQualifiedMemberReference(PsiElement context, String name, @NotNull PsiClass containingClass, boolean isStatic) throws IncorrectOperationException {
        PsiReferenceExpression ref;
        PsiManager manager = containingClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        if (isStatic) {
            ref = (PsiReferenceExpression)factory.createExpressionFromText("A." + name, context);
            PsiJavaCodeReferenceElement qualifier = (PsiJavaCodeReferenceElement)ref.getQualifierExpression();
            PsiReferenceExpression classReference2 = factory.createReferenceExpression(containingClass);
            qualifier.replace((PsiElement)classReference2);
        } else {
            PsiClass contextClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass, (PsiClass)containingClass, (boolean)true)) {
                PsiReferenceExpression ref2 = (PsiReferenceExpression)factory.createExpressionFromText("this." + name, context);
                return ref2;
            }
            while (contextClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass, (PsiClass)containingClass, (boolean)true)) {
                contextClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)contextClass, PsiClass.class, (boolean)true);
            }
            ref = (PsiReferenceExpression)factory.createExpressionFromText("A.this." + name, null);
            PsiJavaCodeReferenceElement qualifier = ((PsiThisExpression)ref.getQualifierExpression()).getQualifier();
            PsiJavaCodeReferenceElement classReference3 = factory.createClassReferenceElement(contextClass != null ? contextClass : containingClass);
            qualifier.replace((PsiElement)classReference3);
        }
        return ref;
    }

    protected static void findMemberHidesOuterMemberCollisions(PsiMember member, String newName, List<UsageInfo> result2) {
        PsiClass aClass;
        PsiMember patternMember;
        if (member instanceof PsiCompiledElement) {
            return;
        }
        if (member instanceof PsiMethod) {
            PsiMethod patternMethod = (PsiMethod)member.copy();
            try {
                patternMethod.setName(newName);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return;
            }
            patternMember = patternMethod;
        } else {
            patternMember = member;
        }
        PsiClass fieldClass = member.getContainingClass();
        PsiClass psiClass = aClass = fieldClass != null ? fieldClass.getContainingClass() : null;
        while (aClass != null) {
            Object conflict = member instanceof PsiMethod ? aClass.findMethodBySignature((PsiMethod)patternMember, true) : aClass.findFieldByName(newName, false);
            if (conflict != null) {
                ReferencesSearch.search((PsiElement)conflict).forEach(reference -> {
                    PsiElement refElement = reference.getElement();
                    if (refElement instanceof PsiReferenceExpression && ((PsiReferenceExpression)refElement).isQualified()) {
                        return true;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)fieldClass, (PsiElement)refElement, (boolean)false)) {
                        MemberHidesOuterMemberUsageInfo info = new MemberHidesOuterMemberUsageInfo(refElement, member);
                        result2.add((UsageInfo)info);
                    }
                    return true;
                });
            }
            aClass = aClass.getContainingClass();
        }
    }

    protected static void qualifyOuterMemberReferences(List<MemberHidesOuterMemberUsageInfo> outerHides) throws IncorrectOperationException {
        for (MemberHidesOuterMemberUsageInfo usage : outerHides) {
            PsiElement element = usage.getElement();
            PsiJavaCodeReferenceElement collidingRef = (PsiJavaCodeReferenceElement)element;
            PsiMember member = (PsiMember)usage.getReferencedElement();
            PsiReferenceExpression ref = RenameJavaMemberProcessor.createMemberReference(member, (PsiElement)collidingRef);
            collidingRef.replace((PsiElement)ref);
        }
    }

    protected static void findCollisionsAgainstNewName(PsiMember memberToRename, String newName, List<UsageInfo> result2) {
        PsiImportList importList;
        if (!memberToRename.isPhysical()) {
            return;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)memberToRename.getProject());
        ArrayList<PsiReference> potentialConflicts = new ArrayList<PsiReference>();
        for (UsageInfo info : result2) {
            PsiImportStaticStatement[] element = info.getElement();
            if (!(element instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)element).advancedResolve(false).getCurrentFileResolveScope() instanceof PsiImportStaticStatement) || !RenameJavaMemberProcessor.referencesLocalMember(memberToRename, newName, elementFactory, (PsiElement)element)) continue;
            potentialConflicts.add(info.getReference());
        }
        PsiFile containingFile = memberToRename.getContainingFile();
        if (containingFile instanceof PsiJavaFile && (importList = ((PsiJavaFile)containingFile).getImportList()) != null) {
            for (PsiImportStaticStatement staticImport : importList.getImportStaticStatements()) {
                PsiField fieldByName;
                PsiClass targetClass;
                String referenceName = staticImport.getReferenceName();
                if (referenceName != null && !referenceName.equals(newName) || (targetClass = staticImport.resolveTargetClass()) == null) continue;
                HashSet importedMembers = new HashSet();
                if (memberToRename instanceof PsiMethod) {
                    for (PsiMethod method2 : targetClass.findMethodsByName(newName, true)) {
                        if (!method2.getModifierList().hasModifierProperty("static")) continue;
                        importedMembers.add(method2);
                    }
                } else if (memberToRename instanceof PsiField && (fieldByName = targetClass.findFieldByName(newName, true)) != null) {
                    importedMembers.add(fieldByName);
                }
                for (PsiMember member : importedMembers) {
                    ReferencesSearch.search((PsiElement)member, (SearchScope)new LocalSearchScope((PsiElement)containingFile), (boolean)true).forEach(psiReference -> {
                        potentialConflicts.add((PsiReference)psiReference);
                        return true;
                    });
                }
            }
        }
        for (PsiReference potentialConflict : potentialConflicts) {
            PsiElement scope;
            JavaResolveResult resolveResult;
            PsiElement conflictElement;
            if (!(potentialConflict instanceof PsiJavaReference) || (conflictElement = (resolveResult = ((PsiJavaReference)potentialConflict).advancedResolve(false)).getElement()) == null || !((scope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStaticStatement)) continue;
            result2.add((UsageInfo)new MemberHidesStaticImportUsageInfo(potentialConflict.getElement(), conflictElement, (PsiElement)memberToRename));
        }
    }

    private static boolean referencesLocalMember(PsiMember memberToRename, String newName, PsiElementFactory elementFactory, PsiElement context) {
        if (memberToRename instanceof PsiField) {
            return ((PsiReferenceExpression)elementFactory.createExpressionFromText(newName, context)).resolve() != null;
        }
        if (memberToRename instanceof PsiMethod) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)elementFactory.createExpressionFromText(newName + "()", context);
            return callExpression.getMethodExpression().multiResolve(false).length > 0;
        }
        return false;
    }

    protected static void qualifyStaticImportReferences(List<MemberHidesStaticImportUsageInfo> staticImportHides) throws IncorrectOperationException {
        for (MemberHidesStaticImportUsageInfo info : staticImportHides) {
            PsiReference ref = info.getReference();
            if (ref == null) {
                return;
            }
            PsiElement occurrence = ref.getElement();
            PsiElement target = info.getReferencedElement();
            if (!(target instanceof PsiMember) || occurrence == null) continue;
            PsiMember targetMember = (PsiMember)target;
            PsiClass containingClass = targetMember.getContainingClass();
            RenameJavaMemberProcessor.qualifyMember(occurrence, targetMember.getName(), containingClass, true);
        }
    }
}

