/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameWithOptionalReferencesDialog;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class RenamePsiFileProcessor
extends RenamePsiElementProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof PsiFileSystemItem;
    }

    @Override
    public RenameDialog createRenameDialog(Project project2, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return new PsiFileRenameDialog(project2, element, nameSuggestionContext, editor);
    }

    private static boolean getSearchForReferences(PsiElement element) {
        return element instanceof PsiFile ? RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_FILE : RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        if (!RenamePsiFileProcessor.getSearchForReferences(element)) {
            return Collections.emptyList();
        }
        return super.findReferences(element);
    }

    public static class PsiFileRenameDialog
    extends RenameWithOptionalReferencesDialog {
        public PsiFileRenameDialog(Project project2, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
            super(project2, element, nameSuggestionContext, editor);
        }

        @Override
        protected boolean getSearchForReferences() {
            return RenamePsiFileProcessor.getSearchForReferences(this.getPsiElement());
        }

        @Override
        protected void setSearchForReferences(boolean value2) {
            if (this.getPsiElement() instanceof PsiFile) {
                RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_FILE = value2;
            } else {
                RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY = value2;
            }
        }
    }
}

