/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import org.jetbrains.annotations.NotNull;

public class AutomaticOverloadsRenamer
extends AutomaticRenamer {
    public AutomaticOverloadsRenamer(@NotNull PsiMethod method2, String newName) {
        for (PsiMethod overload : this.getOverloads(method2)) {
            if (overload == method2 || overload.findDeepestSuperMethods().length != 0) continue;
            this.myElements.add(overload);
            this.suggestAllNames(overload.getName(), newName);
        }
    }

    @Override
    public String getDialogTitle() {
        return "Rename Overloads";
    }

    @Override
    public String getDialogDescription() {
        return "Rename overloads to:";
    }

    @Override
    public String entityName() {
        return "Overload";
    }

    @Override
    public boolean isSelectedByDefault() {
        return true;
    }

    @NotNull
    protected PsiMethod[] getOverloads(@NotNull PsiMethod method2) {
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        return containingClass.findMethodsByName(method2.getName(), false);
    }
}

