/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticOverloadsRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AutomaticOverloadsRenamerFactory
implements AutomaticRenamerFactory {
    @Override
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element.getLanguage() == JavaLanguage.INSTANCE && element instanceof PsiMethod && !((PsiMethod)element).isConstructor()) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return containingClass != null && containingClass.findMethodsByName(((PsiMethod)element).getName(), false).length > 1;
        }
        return false;
    }

    @Override
    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.overloads");
    }

    @Override
    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isRenameOverloads();
    }

    @Override
    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameOverloads(enabled);
    }

    @Override
    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new AutomaticOverloadsRenamer((PsiMethod)element, newName);
    }
}

