/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class AutomaticTestRenamerFactory
implements AutomaticRenamerFactory {
    @Override
    public boolean isApplicable(@NotNull PsiElement element) {
        return element instanceof PsiClass && TestFrameworks.detectFramework((PsiClass)((PsiClass)element)) == null;
    }

    @Override
    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.tests");
    }

    @Override
    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isToRenameTests();
    }

    @Override
    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameTests(enabled);
    }

    @Override
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new TestsRenamer((PsiClass)element, newName);
    }

    private static class TestsRenamer
    extends AutomaticRenamer {
        public TestsRenamer(PsiClass aClass, String newClassName) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (module2 != null) {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependentsScope((Module)module2);
                PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)aClass.getProject());
                String klassName = aClass.getName();
                Pattern pattern = Pattern.compile(".*" + klassName + ".*");
                HashSet names = new HashSet();
                cache2.getAllClassNames(names);
                for (String eachName : names) {
                    if (!pattern.matcher(eachName).matches()) continue;
                    for (PsiClass eachClass : cache2.getClassesByName(eachName, moduleScope)) {
                        if (TestFrameworks.detectFramework((PsiClass)eachClass) == null) continue;
                        this.myElements.add(eachClass);
                    }
                }
                this.suggestAllNames(aClass.getName(), newClassName);
            }
        }

        @Override
        public String getDialogTitle() {
            return RefactoringBundle.message((String)"rename.tests.title");
        }

        @Override
        public String getDialogDescription() {
            return RefactoringBundle.message((String)"rename.tests.with.the.following.names.to");
        }

        @Override
        public String entityName() {
            return RefactoringBundle.message((String)"entity.name.test");
        }
    }
}

