/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JavaSafeDeleteDelegateImpl
implements JavaSafeDeleteDelegate {
    public void createUsageInfoForParameter(PsiReference reference, List<UsageInfo> usages, PsiParameter parameter, final PsiMethod method2) {
        final int index = method2.getParameterList().getParameterIndex(parameter);
        final PsiElement element = reference.getElement();
        PsiCall call = null;
        if (element instanceof PsiCall) {
            call = (PsiCall)element;
        } else {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiCall) {
                call = (PsiCall)parent;
            } else if (parent instanceof PsiAnonymousClass) {
                call = (PsiNewExpression)parent.getParent();
            }
        }
        if (call != null) {
            PsiExpression[] args;
            PsiExpressionList argList = call.getArgumentList();
            if (argList != null && index < (args = argList.getExpressions()).length) {
                if (!parameter.isVarArgs()) {
                    usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(args[index], (PsiElement)parameter));
                } else {
                    for (int i2 = index; i2 < args.length; ++i2) {
                        usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(args[i2], (PsiElement)parameter));
                    }
                }
            }
        } else if (element instanceof PsiDocMethodOrFieldRef) {
            if (((PsiDocMethodOrFieldRef)element).getSignature() != null) {
                final StringBuffer newText = new StringBuffer();
                newText.append("/** @see #").append(method2.getName()).append('(');
                ArrayList<PsiParameter> parameters2 = new ArrayList<PsiParameter>(Arrays.asList(method2.getParameterList().getParameters()));
                parameters2.remove(parameter);
                newText.append(StringUtil.join(parameters2, psiParameter -> psiParameter.getType().getCanonicalText(), (String)","));
                newText.append(")*/");
                usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)parameter, true){

                    @Override
                    public void deleteElement() throws IncorrectOperationException {
                        PsiDocMethodOrFieldRef.MyReference javadocMethodReference = (PsiDocMethodOrFieldRef.MyReference)element.getReference();
                        if (javadocMethodReference != null) {
                            javadocMethodReference.bindToText(method2.getContainingClass(), newText);
                        }
                    }
                });
            }
        } else if (element instanceof PsiMethodReferenceExpression) {
            usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)parameter, true){

                @Override
                public void deleteElement() throws IncorrectOperationException {
                    PsiExpression[] args;
                    PsiExpressionList expressionList;
                    PsiExpression callExpression = LambdaRefactoringUtil.convertToMethodCallInLambdaBody((PsiMethodReferenceExpression)element);
                    if (callExpression instanceof PsiCallExpression && (expressionList = ((PsiCallExpression)callExpression).getArgumentList()) != null && index < (args = expressionList.getExpressions()).length) {
                        args[index].delete();
                    }
                }
            });
        }
    }
}

